% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.4d.R
\name{read.4D}
\alias{read.4D}
\title{Read data from 4D database}
\usage{
read.4D(file, info = interactive(), header = TRUE, row.names = NULL,
  sep = "\\t", quote = "\\"'", dec = ",", na.strings = c("NA", "",
  "."), skip = 2, check.names = TRUE, strip.white = TRUE,
  fill = TRUE, blank.lines.skip = TRUE, stringsAsFactors = FALSE,
  fileEncoding = "UTF-8", encoding = "UTF-8")
}
\arguments{
\item{file}{the name of the file which the data are to be read from.
    Each row of the table appears as one line of the file.  If it does
    not contain an \emph{absolute} path, the file name is
    \emph{relative} to the current working directory,
    \code{\link{getwd}()}. Tilde-expansion is performed where supported.
    This can be a compressed file (see \code{\link{file}}).

    Alternatively, \code{file} can be a readable text-mode
    \link{connection} (which will be opened for reading if
    necessary, and if so \code{\link{close}}d (and hence destroyed) at
    the end of the function call).  (If \code{\link{stdin}()} is used,
    the prompts for lines may be somewhat confusing.  Terminate input
    with a blank line or an EOF signal, \code{Ctrl-D} on Unix and
    \code{Ctrl-Z} on Windows.  Any pushback on \code{stdin()} will be
    cleared before return.)

    \code{file} can also be a complete URL.  (For the supported URL
    schemes, see the \sQuote{URLs} section of the help for
    \code{\link{url}}.)
  }

\item{info}{a logical to indicate whether info about the import should be printed, defaults to \code{TRUE} in interactive sessions}

\item{header}{a logical value indicating whether the file contains the
    names of the variables as its first line.  If missing, the value is
    determined from the file format: \code{header} is set to \code{TRUE}
    if and only if the first row contains one fewer field than the
    number of columns.}

\item{row.names}{a vector of row names.  This can be a vector giving
    the actual row names, or a single number giving the column of the
    table which contains the row names, or character string giving the
    name of the table column containing the row names.

    If there is a header and the first row contains one fewer field than
    the number of columns, the first column in the input is used for the
    row names.  Otherwise if \code{row.names} is missing, the rows are
    numbered.

    Using \code{row.names = NULL} forces row numbering. Missing or
    \code{NULL} \code{row.names} generate row names that are considered
    to be \sQuote{automatic} (and not preserved by \code{\link{as.matrix}}).
  }

\item{sep}{the field separator character.  Values on each line of the
    file are separated by this character.  If \code{sep = ""} (the
    default for \code{read.table}) the separator is \sQuote{white space},
    that is one or more spaces, tabs, newlines or carriage returns.}

\item{quote}{the set of quoting characters. To disable quoting
    altogether, use \code{quote = ""}.  See \code{\link{scan}} for the
    behaviour on quotes embedded in quotes.  Quoting is only considered
    for columns read as character, which is all of them unless
    \code{colClasses} is specified.}

\item{dec}{the character used in the file for decimal points.}

\item{na.strings}{a character vector of strings which are to be
    interpreted as \code{\link{NA}} values.  Blank fields are also
    considered to be missing values in logical, integer, numeric and
    complex fields.  Note that the test happens \emph{after} 
    white space is stripped from the input, so \code{na.strings} 
    values may need their own white space stripped in advance.}

\item{skip}{integer: the number of lines of the data file to skip before
    beginning to read data.}

\item{check.names}{logical.  If \code{TRUE} then the names of the
    variables in the data frame are checked to ensure that they are
    syntactically valid variable names.  If necessary they are adjusted
    (by \code{\link{make.names}}) so that they are, and also to ensure
    that there are no duplicates.}

\item{strip.white}{logical. Used only when \code{sep} has
    been specified, and allows the stripping of leading and trailing
    white space from unquoted \code{character} fields (\code{numeric} fields
    are always stripped).  See \code{\link{scan}} for further details
    (including the exact meaning of \sQuote{white space}),
    remembering that the columns may include the row names.}

\item{fill}{logical. If \code{TRUE} then in case the rows have unequal
    length, blank fields are implicitly added.  See \sQuote{Details}.}

\item{blank.lines.skip}{logical: if \code{TRUE} blank lines in the
    input are ignored.}

\item{stringsAsFactors}{logical: should character vectors be converted
    to factors?  Note that this is overridden by \code{as.is} and
    \code{colClasses}, both of which allow finer control.}

\item{fileEncoding}{character string: if non-empty declares the
    encoding used on a file (not a connection) so the character data can
    be re-encoded.  See the \sQuote{Encoding} section of the help for
    \code{\link{file}}, the \sQuote{R Data Import/Export Manual} and
    \sQuote{Note}.
  }

\item{encoding}{encoding to be assumed for input strings.  It is
    used to mark character strings as known to be in
    Latin-1 or UTF-8 (see \code{\link{Encoding}}): it is not used to
    re-encode the input, but allows \R to handle encoded strings in
    their native encoding (if one of those two).  See \sQuote{Value}
    and \sQuote{Note}.
  }
}
\description{
This function is only useful for the MMB department of the UMCG. Use this function to \strong{import data by just defining the \code{file} parameter}. It will automatically transform birth dates and calculate patients age, translate the column names to English, transform the \code{mo} with \code{\link{as.mo}} and transform all antimicrobial columns with \code{\link{as.rsi}}.
}
\details{
Column names will be transformed, but the original column names are set as a "label" attribute and can be seen in e.g. RStudio Viewer.
}
