% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi_analysis.R
\name{rsi_predict}
\alias{rsi_predict}
\title{Predict antimicrobial resistance}
\usage{
rsi_predict(tbl, col_ab, col_date = "ontvangstdatum",
  year_max = as.integer(format(as.Date(Sys.Date()), "\%Y")) + 15,
  year_every = 1, model = "binomial", I_as_R = TRUE,
  preserve_measurements = TRUE, info = TRUE)
}
\arguments{
\item{tbl}{table that contains columns \code{col_ab} and \code{col_date}}

\item{col_ab}{column name of \code{tbl} with antimicrobial interpretations (\code{R}, \code{I} and \code{S})}

\item{col_date}{column name of the date, will be used to calculate years}

\item{year_max}{highest year to use in the prediction model, deafults to 15 years after today}

\item{year_every}{unit of sequence between lowest year found in the data and \code{year_max}}

\item{model}{the statistical model of choice. Valid values are \code{"binomial"} (or \code{"binom"} or \code{"logit"}) or \code{"loglin"} or \code{"linear"} (or \code{"lin"}).}

\item{I_as_R}{treat \code{I} as \code{R}}

\item{preserve_measurements}{overwrite predictions of years that are actually available in the data, with the original data. The standard errors of those years will be \code{NA}.}

\item{info}{print textual analysis with the name and \code{\link{summary}} of the model.}
}
\value{
\code{data.frame} with columns \code{year}, \code{probR}, \code{se_min} and \code{se_max}.
}
\description{
Create a prediction model to predict antimicrobial resistance for the next years on statistical solid ground. Standard errors (SE) will be returned as columns \code{se_min} and \code{se_max}.
}
\examples{
\dontrun{
# use it directly:
rsi_predict(tbl[which(first_isolate == TRUE & genus == "Haemophilus"),], "amcl")
  
# or with dplyr so you can actually read it:
library(dplyr)
tbl \%>\%
  filter(first_isolate == TRUE,
         genus == "Haemophilus") \%>\%
  rsi_predict("amcl")

tbl \%>\%
  filter(first_isolate_weighted == TRUE,
         genus == "Haemophilus") \%>\%
  rsi_predict(col_ab = "amcl",
              year_max = 2050,
              year_every = 5)

}
}
\seealso{
\code{\link{lm}} \cr \code{\link{glm}}
}
