% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_7_table_23}
\alias{chapter_7_table_23}
\alias{C7T23}
\alias{Chapter_7_Table_23}
\alias{c7t23}
\title{The data used in Chapter 7, Table 23}
\format{
An object of class \code{data.frame} with 45 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_7_table_23)
}
\description{
The data used in Chapter 7, Table 23
}
\details{
Suppose that a clinical psychologist is interested in comparing the relative effectiveness of three forms of psychotherapy for alleviating depression. Fifteen individuals are randomly assigned to one of each of three treatment groups: cognitive-behavioral, Rogerian, and assertiveness training. The Depression Scale of the MMPI serves as the dependent variable. After the fact, these individuals where placed into one of three categories based on the severity of their depression. Thus, this data set represents a 3 by 3 nonorthogonal factorial design with post hoc blocking. Table 7.23 shows hypothetical MMPI scores for 45 participants, each of whom is placed in one cell of a 3x3 design. One factor (A, the row factor) is type of therapy. The other factor (B, the column factor) is degree of severity.

The data represents the relative effectiveness of three forms of psychotherapy for alleviating depression. Fifteen individuals were randomly assigned to one of three groups. After the fact, these individuals where placed into one of three categories based on the severity of their depression. Thus, this data set represents a 3 by 3 nonorthogonal factorial design with post hoc blocking.
}
\section{Variables}{

\describe{
\item{therapy}{the type of therapy}
\item{severity}{the severity of the therapy}
\item{score}{the score of the individual}
}
}

\section{Synonym}{

C7T23
}

\examples{
# Load the data
data(chapter_7_table_23)

# Or, alternatively load the data as
data(C7T23)

# View the structure
str(chapter_7_table_23)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
