% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run.R
\docType{methods}
\name{run}
\alias{run}
\alias{gui}
\title{Run AMAPVox}
\usage{
run(
  version = "latest",
  xml,
  java = "java",
  jvm.options = "-Xms2048m",
  nt = 1,
  ntt = 1,
  stdout = ""
)

gui(version = "latest", java = "java", jvm.options = "-Xms2048m", stdout = "")
}
\arguments{
\item{version, }{either "latest" or a valid version number major.minor(.build)
if \code{version="latest"} the function looks for latest remote version. If
there is no internet connection it runs latest local version.}

\item{xml}{path(s) to AMAPVox XML configuration files. If missing or \code{NULL}
AMAPVox launches the GUI.}

\item{java}{path to the java executable. Default 'java' value assumes that
java is correctly defined on the $PATH variable.}

\item{jvm.options}{JVM (Java Virtual Machine) options. By default it
allocates 2Go of heap memory to AMAPVox.}

\item{nt}{maximum number of threads for running tasks. \code{nt=1} means
sequential execution. \code{nt=0} means as many threads as available.}

\item{ntt}{maximum number of threads per task. \code{ntt=0} means as many threads
as available.}

\item{stdout}{where output from both stdout/stderr should be sent. Same as
stdout & stderr options from function \code{\link[=system2]{system2()}}.}
}
\description{
Run AMAPVox either in batch mode or with Graphical User
Interface (GUI). The function embeds a version manager for installing
locally any version available remotely. AMAPVox relies on Java 64 bit. It
has been compiled with JDK 8 64-Bit Oracle. For running AMAPVox in batch
mode, any version of Java 64-bit >= 8 should work. AMAPVox GUI relies
additionally on JavaFX. Refer to following section for installing a
suitable Java/JavaFX.

\code{gui} function as been kept for background compatibility. It is an
alias of the \code{run} function.
}
\section{Java 1.8 64-Bit with JavaFX}{
 AMAPVox GUI relies on Java 1.8 64-Bit
and JavaFX. In practice it requires either \href{https://java.com/download/}{Java 1.8 64-Bit Oracle} or \href{https://aws.amazon.com/fr/corretto/}{Java 1.8 64-Bit Corretto}. OpenJDK 8 will not work
since JavaFX is not included. You may check beforehand if java is installed
on your system and which version.

\if{html}{\out{<div class="sourceCode">}}\preformatted{system2("java", args = "-version")
}\if{html}{\out{</div>}}

If AMAPVox::gui keeps throwing errors after you have installed suitable
Java 1.8 64-Bit, it means that Java 1.8 may not be properly detected by
your system. In such case you may have to check and set the \code{JAVA_HOME}
environment variable.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Sys.getenv("JAVA_HOME")
Sys.setenv(JAVA_HOME="path/to/java/1.8/bin")
system2("java", args = "-version")
}\if{html}{\out{</div>}}

As a last resort you may change the \code{java} parameter of
this function and set the full path to Java 1.8 binary.

\if{html}{\out{<div class="sourceCode">}}\preformatted{AMAPVox::run(java = "/path/to/java/1.8/bin/java")
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
# (install and )run latest AMAPVox version with GUI
AMAPVox::run()
# (install and )run version 1.6.4 with GUI
AMAPVox::run(version="1.6.4")
# run latest AMAPVox version with XML configuration
AMAPVox::run(xml="/path/to/cfg.xml")
# run multiple configurations
AMAPVox::run(xml=c("cfg1.xml", "cfg2.xml"), nt=2)
}
}
\seealso{
\code{\link[=getLocalVersions]{getLocalVersions()}}, \code{\link[=getRemoteVersions]{getRemoteVersions()}}, \code{\link[=installVersion]{installVersion()}} and
\code{\link[=removeVersion]{removeVersion()}}
}
