% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{compare.fus}
\alias{compare.fus}
\title{Comparing designs using FUS}
\usage{
compare.fus(...)
}
\arguments{
\item{...}{Objects created by \code{\link{pv.fus.rc}} or
\code{\link{pv.fus.ic}}.}
}
\value{
FUS plots of multiple designs.
}
\description{
\code{\link{compare.fus}} draws the FUS plots of multiple designs on a
single frame.
}
\examples{
\dontrun{
# Generating D optimal design and FUS plot.
Dopt <- altopt.rc("D", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01))

FUS.D <- pv.fus.rc(Dopt$opt.design.rounded, 100, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

# Generating U optimal design and FUS plot.
Uopt <- altopt.rc("U", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useCond = c(1.758, 3.159))

FUS.U <- pv.fus.rc(Uopt$opt.design.rounded, 100, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

# Comparing D and U optimal designs.
compare.fus(FUS.D, FUS.U)
}
}
\seealso{
\code{\link{pv.fus.rc}}, \code{\link{pv.fus.ic}}
}

