% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AGread_utils.R, R/RcppExports.R
\name{get_VM}
\alias{get_VM}
\alias{get_VM_C}
\title{Calculate vector magnitude}
\usage{
get_VM(triaxial, method = c("legacy", "Rcpp"), verbose = FALSE)

get_VM_C(x, y, z)
}
\arguments{
\item{triaxial}{a dataframe of triaxial data on which to calculate vector
magnitude}

\item{method}{which method to use, either \code{legacy} (default, for
backwards compatibility) or \code{Rcpp} (gives the same results, faster but
more particular)}

\item{verbose}{print information about variable search criteria?}

\item{x}{NumericVector. X-axis values}

\item{y}{NumericVector. Y-axis values}

\item{z}{NumericVector. Z-axis values}
}
\value{
a vector of vector magnitude values
}
\description{
Calculate vector magnitude
}
\examples{
data(imu_to_collapse)

vm_columns <-
    grepl("accelerometer",
        names(imu_to_collapse),
        ignore.case = TRUE)

vm_values <- get_VM(
  data.frame(imu_to_collapse)[, vm_columns]
)

head(vm_values)

}
\keyword{internal}
