% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindCentersAutoV.R
\name{FindCentersAutoV}
\alias{FindCentersAutoV}
\title{Automatically find centers with vertical threshold}
\usage{
FindCentersAutoV(f, delta, f.cut = c(0.1, 0.2, 0.3), nclust, rm.dup = TRUE)
}
\arguments{
\item{f}{vector of local distance f(x). See the detail section of the help(adpclust).}

\item{delta}{vector of minimal distances to higher ground delta(x). See the detail section of the help(adpclust).}

\item{f.cut}{number between (0, 1) or numeric vector of numbers between (0, 1). Data points whose f values are larger than f.cut with large delta values are selected as centers. The default is c(0.1, 0.2, 0.3).}

\item{nclust}{number of clusters. It can be either a single integer or a vector of integers.}

\item{rm.dup}{boolean. If TRUE (default) duplicated centers vectors are removed from returned list.}
}
\value{
a list of vectors. Each vector contains the indices of selected centers.
}
\description{
Automatically find centers with vertical threshold vertical f(x) thresholds.
}
\details{
Given f's and delta's, cluster centers are chosen to be the data points whose delta values are high and f values are larger than a fixed threshold. To be more specific, let F denote the set of all f(x). centers are selected as points with the largest m delta values in the set {x | f(x) > a'th percentile of F}. The number of centers m is given by the parameter nclust. The cutting percentile a is given by the parameter f.cut. When at least one of these two parameters are vectors, centers are selected based all combinations of them, and returned in a list.
}
\author{
Ethan Xu
}

