% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\name{compute_ph_p_cna_nm}
\alias{compute_ph_p_cna_nm}
\title{Compute "Child Nutrition Assessment [Parent]: Sum [Validation: No more than
0 missing or declined]"}
\usage{
compute_ph_p_cna_nm(
  data,
  name = "ph_p_cna_nm",
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{exclude}{character, Values to be excluded from the summary score.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_p_cna_sum}
Child Nutrition Assessment [Parent]: Sum [Validation: No more than 0
missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_p_cna_001}
\item \code{ph_p_cna_002}
\item \code{ph_p_cna_003}
\item \code{ph_p_cna_004}
\item \code{ph_p_cna_005}
\item \code{ph_p_cna_006}
\item \code{ph_p_cna_007}
\item \code{ph_p_cna_008}
\item \code{ph_p_cna_009}
\item \code{ph_p_cna_010}
\item \code{ph_p_cna_011}
\item \code{ph_p_cna_012}
\item \code{ph_p_cna_013}
\item \code{ph_p_cna_014}
}
\item \emph{Excluded values:}
\itemize{
\item 999
\item 777
}
}
}
\examples{
\dontrun{
compute_ph_p_cna_nm(data) |>
  select(
    all_of(c("ph_p_cna_nm", vars_ph_p_cna))
  )
}
}
