% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/phases.R
\docType{methods}
\name{as_phases}
\alias{as_phases}
\alias{as_phases-method}
\alias{as_phases,matrix-method}
\alias{as_phases,data.frame-method}
\title{Coerce to Phases}
\usage{
as_phases(from, ...)

\S4method{as_phases}{matrix}(
  from,
  calendar = get_calendar(),
  start = seq(from = 1, to = ncol(from), by = 2),
  stop = start + 1,
  names = NULL,
  iteration = NULL
)

\S4method{as_phases}{data.frame}(
  from,
  calendar = get_calendar(),
  start = seq(from = 1, to = ncol(from), by = 2),
  stop = start + 1,
  names = NULL,
  iteration = NULL
)
}
\arguments{
\item{from}{from An object to be coerced.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the source
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}

\item{start}{An \code{\link{integer}} vector specifying the index of the columns
corresponding to the beginning of the phases. If missing, every other column
is used starting from the first column (after deleting the \code{iteration}
column, if any).}

\item{stop}{An \code{\link{integer}} vector specifying the index of the columns
corresponding to the end of the phases. If missing, every other column
is used starting from the second column (after deleting the \code{iteration}
column, if any).}

\item{names}{A \code{\link{character}} vector giving the names of the phases.}

\item{iteration}{A length-one \code{\link{numeric}} vector specifying the index of the
iteration column.}
}
\value{
A \code{\linkS4class{PhasesMCMC}} object.
}
\description{
Coerce to Phases
}
\examples{
## Coerce to phases
(pha <- as_phases(mcmc_phases, calendar = CE(), start = c(1, 3), iteration = 1))
summary(pha, calendar = CE())

## Plot phases
plot(pha)
plot(pha, succession = "hiatus")
plot(pha, succession = "transition")

## Compute phases from events
(eve <- as_events(mcmc_events, calendar = CE(), iteration = 1))

## Compute min-max range for all chains
pha1 <- phases(eve)
summary(pha1, calendar = CE())

## Compute min-max range by group
pha2 <- phases(eve, groups = list(phase_1 = c(1, 3), phase_2 = c(2, 4)))
summary(pha2, calendar = CE())
}
\seealso{
Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{check}},
\code{\link{read_bcal}()},
\code{\link{read_chronomodel}},
\code{\link{read_oxcal}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{read methods}
