% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_plot_PLM_mut_vs_cons.R
\name{Af_plot_PLM_mut_vs_cons}
\alias{Af_plot_PLM_mut_vs_cons}
\title{Function to create a boxplot of the Protein Language Model probabilities}
\usage{
Af_plot_PLM_mut_vs_cons(
  PLM_dataframe,
  values,
  dots,
  group_by,
  colors,
  font.size,
  output.file
)
}
\arguments{
\item{PLM_dataframe}{Dataframe resulting from Af_PLM_dataframe(). This contains the Protein Language Model probabilities and ranks of the mutations along the edges of B cell lineage trees.}

\item{values}{What values to plot. Can be "rank" (default) or "probability".
"rank" will plot the rank of the amino acid (Highest probability is rank 1).
"probability" will plot the probability of the amino acid.}

\item{dots}{Whether to plot the individual points. Can be "none" (default), "all_edges", "sample_average"}

\item{group_by}{Color the dots on a group. Can be "none" (default), "sample_id", or "n_subs".}

\item{colors}{Color to use for the dots. When group_by = "sample_id": This should be a vector of the same length as the number of samples.}

\item{font.size}{Font size for the plot. Default is 16.}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A ggplot2 object of the PLM boxplot
}
\description{
Function to create a boxplot of the Protein Language Model probabilities and ranks of the mutating vs. conserved residues along the edges of B cell lineage trees.
}
\examples{
Af_plot_PLM_mut_vs_cons(PLM_dataframe = AntibodyForests::PLM_dataframe,
            values = "probability")
}
