% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{kneighbors_distance_docall}
\alias{kneighbors_distance_docall}
\title{K-Nearest neighbors algorithm to compute an anomaly score}
\usage{
kneighbors_distance_docall(knn, distance, dparams)
}
\arguments{
\item{knn}{number of nearest neighbors to consider for the anomaly score}

\item{distance}{function name of the available distance matrices}

\item{dparams}{a list with all the parameters for the distance matrix}
}
\value{
A list of two elements with the anomaly scores and the distance
matrix
}
\description{
The method obtain a distance matrix and find the K-nearest neighbors of
each series and sum their distances in the neighborhood.
The sum is defined as the anomaly score, the series with higher scores
implies their neighbors are far away and such a series is a potential
outlier
}
\examples{
X=matrix( rnorm(2000), ncol=10  )
distance=distance_matrix_coherence
dparams=list(unit=X, span1=2, span2=2, period = 5 )
knn=5
kneighbors_distance_docall(knn,distance, dparams)
}
\seealso{
Guillermo Granados, and Idris Eckley. "Electricity Demand of Buildings Benchmarked via Regression Trees on Nearest Neighbors Anomaly Scores"
}
