% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_CGCI}
\alias{distance_matrix_CGCI}
\title{Pairwise distance matrix based on the conditional Granger causality index}
\usage{
distance_matrix_CGCI(unit, pmax)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}

\item{pmax}{maximum order(lag) of the VAR model to be considered}
}
\value{
a matrix with pairwise distances
}
\description{
Pairwise distance matrix of a multivariate time series based on the
the conditional Granger causality index distance between two series
}
\examples{
X=matrix( rnorm(2000), ncol=10  )
pmax=4
distance_matrix_CGCI(unit=X, pmax)
}
\seealso{
Siggiridou, Elsa, and Dimitris Kugiumtzis. "Granger Causality
in Multivariate Time Series Using a Time-Ordered Restricted Vector
Autoregressive Model." IEEE Transactions on Signal Processing 64, no.
7 (April 2016): 1759-73. \doi{10.1109/TSP.2015.2500893}
}
