% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{Anomalyscoresframe}
\alias{Anomalyscoresframe}
\title{Anomaly score computation for a set of distances}
\usage{
Anomalyscoresframe(unit, knn, measures, dparams)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}

\item{knn}{number of nearest neighbors to consider for the anomaly scores}

\item{measures}{vector with the indexes of the selected measures
1=Cort, 2=Wasserstein, 3=Mahalanobis, 4=Normalized Cort,
5=Coherence, 6=PDC, 7=CGCI,8=RGPDC, 9=PMIME, 10=mvLWS, 11=Band depth}

\item{dparams}{a list where each element is a list with all the parameters
necessary to compute the selected distances. If the distance does not need
further parameters then define an empty list}
}
\value{
A dataframe with the names of series in unit as a column called
"series" and the corresponding scores computed for each distance. The rank is
ordered with respect to the first measure in the measures index vector
}
\description{
Computes anomaly scores for a selection of different distances
for a single dataset.
}
\examples{
unit=matrix( rnorm(500), ncol=5  )
measures= c(1,5,11 ) # Cort, Coherence and Band depth
knn=3
dparams=list(
  list(k=2),
  list( span1=2, span2=2, period = 5),
  list( )
)
Anomalyscoresframe(unit, knn,measures, dparams)
}
\seealso{
Guillermo Granados, and Idris Eckley. "Electricity Demand of Buildings Benchmarked via Regression Trees on Nearest Neighbors Anomaly Scores"
}
