% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T3Test.R
\name{T3Test}
\alias{T3Test}
\title{Dunnett's T3 Post Hoc Test v2.2.0}
\usage{
T3Test(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm} (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"dunnettt3"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, mean differences,
        \code{q_value}, \code{gl}, \code{p_value}, and significance indicators.
  \item \code{Promedios}: A named numeric vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: A character vector of group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string with the test name ("Dunnett T3").
  \item \code{Termino}: The term being compared (e.g., "A", "B", or "A:B").
}
}
\description{
Performs Dunnett's T3 test for pairwise comparisons after an ANOVA model.
This test is recommended when group variances are unequal and sample sizes differ.
It is based on the studentized range distribution and provides conservative control
over Type I error without assuming homoscedasticity.
}
\details{
Advantages:
- More powerful than T2 when group sizes are small.
- Adjusted for unequal variances.

Disadvantages:
- Complex critical value estimation.
- Less frequently used and harder to find in software.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- T3Test(mod)
summary(resultado)
plot(resultado)

# Con bloques, comparando solo el factor de interés
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res2 <- T3Test(mod2, comparar = "as.factor(labor)")
summary(res2)
plot(res2)

# Modelo con interacción
mod3 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
res3 <- T3Test(mod3, comparar = c("as.factor(labor)", "Sexo"))
summary(res3)
plot(res3)

}
\references{
Dunnett, C. W. (1980). "Pairwise multiple comparisons in the unequal variance case."
\emph{Journal of the American Statistical Association}, 75(372), 796–800.
<https://doi.org/10.1080/01621459.1980.10477558>
}
