% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamesHowellTest.R
\name{GHTest}
\alias{GHTest}
\title{Games-Howell Post Hoc Test v.2.2.0}
\usage{
GHTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"gameshowell"} and \code{"comparaciones"},
which contains:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, including:
        \code{Comparacion}, \code{Diferencia}, \code{t_value}, \code{gl},
        \code{p_value}, and \code{Significancia}.
  \item \code{Promedios}: A named numeric vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string indicating the method used ("Games-Howell").
  \item \code{Termino}: The term being compared (e.g., "A", "B", or "A:B").
}
}
\description{
Performs the Games-Howell test for pairwise comparisons after ANOVA,
without assuming equal variances or sample sizes. It is suitable when
Levene or Bartlett test indicates heterogeneity of variances.
}
\details{
Advantages:
- Excellent for heteroscedastic data.
- Controls Type I error across unequal group sizes.

Disadvantages:
- Slightly conservative in small samples.
- More complex to compute than Tukey.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
# Comparación sobre el primer factor del modelo
resultado <- GHTest(mod)
summary(resultado)
plot(resultado)

# Con bloques, comparando solo el factor de interés
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res2 <- GHTest(mod2, comparar = "as.factor(labor)")
summary(res2)
plot(res2)

# Modelo con interacción
mod3 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
# efecto principal
resA <- GHTest(mod3, comparar = "as.factor(labor)")
# interacción
resAB <- GHTest(mod3, comparar = c("as.factor(labor)", "Sexo"))
summary(resAB)
plot(resAB)
}
\references{
Games, P. A., & Howell, J. F. (1976).
"Pairwise Multiple Comparison Procedures with Unequal N's and/or Variances:
A Monte Carlo Study". Journal of Educational Statistics, 1(2), 113–125.
<https://doi.org/10.1002/j.2162-6057.1976.tb00211.x>
}
