% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSCFTest.R
\name{DSCFTest}
\alias{DSCFTest}
\title{Dwass-Steel-Critchlow-Fligner (DSCF) Test (Non-Parametric) v2.0.3}
\usage{
DSCFTest(
  formula,
  data,
  alpha = 0.05,
  method.p = "holm",
  na.rm = TRUE,
  include_kw = TRUE
)
}
\arguments{
\item{formula}{y ~ group}

\item{data}{data.frame con las variables}

\item{alpha}{nivel (0.05 por defecto)  just for the little star}

\item{method.p}{adjustment method (default "holm")}

\item{na.rm}{remove NA (TRUE by default)}

\item{include_kw}{if TRUE, add summary of Kruskal-Wallis test}
}
\value{
objeto con clases c("comparaciones","dscf")
}
\description{
Robust non-parametric method for multiple comparisons after Kruskal-Wallis.
Uses rank-based pairwise tests with a pooled variance estimate.
}
\details{
Advantages:
- Strong control of Type I error with unequal sample sizes.
- More powerful than Dunn in many conditions.

Disadvantages:
- Computationally more complex.
- Less commonly available in standard software.
- It is only useful in completely random or single-factor designs.
}
\examples{
data(d_e, package = "Analitica")
DSCFTest(Sueldo_actual ~ labor, data = d_e)

}
\references{
Dwass, M. (1960). Some k-sample rank-order tests. In I. Olkin et al. (Eds.), Contribution1s to Probability and Statistics: Essays in Honor of Harold Hotelling (pp. 198 - 202). Stanford University Press.
}
