% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\docType{class}
\name{AmigaBasic}
\alias{AmigaBasic}
\title{The S3 AmigaBasic class}
\description{
A class that represents the content of Amiga Basic files.
}
\details{
Amiga Basic is a \href{https://en.wikipedia.org/wiki/BASIC}{BASIC}-style programming language that was shipped
with early Commodore Amiga machines. It requires an interpreter to run an Amiga Basic script. The AmigaFFH
package does not interpret Amiga Basic scripts. It does allow for encoding and decoding scripts in the binary
format in which it was originally stored on the Amiga. Amiga Basic scripts were stored as encoded binaries instead
of ASCII text files in order to save (at the time precious) memory and disk space.

Amiga Basic binary files start with a file header (as an identifier) and is followed by each line of the script
as binary data. The \code{AmigaBasic}-class object stores each line of the script as a \code{list} item as a \code{vector}
of \code{raw} data. Use \code{\link[=as.character]{as.character()}} and \code{\link[=as.AmigaBasic]{as.AmigaBasic()}} to switch between
\code{character} data and \code{AmigaBasic}-class objects.
}
\note{
Although there is ample reference material on the Amiga BASIC language, there is no documentation
available on the script file storage format. The implementation in the AmigaFFH package is all the result of
painstaking reverse engineering on my part. Consequently the Amiga Basic file encoders and decoders implemented
here may not be infallible.
}
\examples{
## This creates an AmigaBasic-class object:
bas <- as.AmigaBasic("PRINT \"hello world!\"")

## This will decode the object as plain text:
as.character(bas)
}
\references{
\url{https://en.wikipedia.org/wiki/AmigaBASIC}
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{write.AmigaBasic}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
