# AlgeriAPIs - Access Algerian Data via Public APIs
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# algiers_temp_df


library(testthat)

# Test 1: Confirm the object is a data.frame (not a tibble)
test_that("algiers_temp_df is a data.frame", {
  expect_s3_class(algiers_temp_df, "data.frame")
  expect_false("tbl_df" %in% class(algiers_temp_df))  # Ensure it's not a tibble
})

# Test 2: Confirm it has exactly 3 columns
test_that("algiers_temp_df has 3 columns", {
  expect_equal(length(algiers_temp_df), 3)
})

# Test 3: Confirm it has exactly 16436 rows
test_that("algiers_temp_df has 16436 rows", {
  expect_equal(nrow(algiers_temp_df), 16436)
})

# Test 4: Confirm column names are correct and in order
test_that("algiers_temp_df has correct column names", {
  expect_named(algiers_temp_df, c("t", "tMax", "tMin"))
})

# Test 5: Confirm column types are correct
test_that("algiers_temp_df columns have correct types", {
  expect_s3_class(algiers_temp_df$t, "Date")
  expect_type(algiers_temp_df$tMax, "double")
  expect_type(algiers_temp_df$tMin, "double")
})
