% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airportgame.R
\name{airportgame}
\alias{airportgame}
\title{Coalitional game associated with an airport problem}
\usage{
airportgame(c, lex = TRUE)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{lex}{A logical value indicating the output order of the game. By default, \code{lex = TRUE} returns the game in lexicographic order. However, if \code{lex = FALSE}, the game is returned in binary order.}
}
\value{
A numeric vector representing the associated coalitional game.
}
\description{
\code{airportgame} computes the coalitional game for cost-sharing in an airport problem.
}
\details{
Let \eqn{N = \{1, \dots, n\}} denote the set of agents, and let \eqn{c \in \mathbb{R}_+^N} be the cost vector such that
\eqn{c \geq 0}. The value \eqn{c_i} should be interpreted as the associated cost for each agent \eqn{i} in the context of
the problem, i.e., every component represents the cost of the facility required by an agent.
Segmental costs are defined as the difference between a given cost and the first immediately lower cost: \eqn{c_i - c_{i-1}} for \eqn{i \in N \backslash \{1\}}.
Therefore, \eqn{C^N} represents the domain of all problems.

Given an airport problem \eqn{c \in \mathbb{R}^N_{+}}, the corresponding coalitional game is defined, for each \eqn{S \subseteq N}, as:

\deqn{
v(S) = \max\{c_j : j \in S\}.
}

It is easy to check that this class of games associated with airport problems is always concave, since for any pair of coalitions
\eqn{S \subseteq T \subseteq N}, it is verified that:

\deqn{
v(S \cup \{i\}) - v(S) \geq v(T \cup \{i\}) - v(T) \quad \text{for all} \quad i \notin T
}

An efficient way to represent a nonempty coalition \eqn{S \in 2^N} is by identifying it with the binary sequence
\eqn{a_n,a_{n-1},\dots a_1}, where \eqn{a_i=1} if \eqn{i \in S} and \eqn{a_i=0} otherwise. Consequently, each coalition
\eqn{S} is represented by the number associated with its binary representation: \eqn{\sum_{i \in S} 2^{i-1}}.
Then coalitions can be ordered by their associated numbers.

Alternatively, coalitions can be ordered lexicographically, meaning they are first sorted by increasing size,
and then by lexicographic order among coalitions of the same size.
}
\examples{
# 4 agents
(c <- c(1, 3, 7, 10)) # Vector of costs
airportgame(c, lex = TRUE)  # Game in lexicographic order
airportgame(c, lex = FALSE) # Game in binary order

}
\references{
Littlechild, S. C. and Owen, G. (1973). A simple expression for the Shapley value in a special case.
\emph{Management Science}, 23, 370-372.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{airportvector}}
}
