% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFCrule.R
\name{SFCrule}
\alias{SFCrule}
\title{Sequential full contributions rule}
\usage{
SFCrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{SFCrule} calculates the contribution vector selected by the SFC rule.
}
\details{
For each \eqn{c\in C^N} and each \eqn{i\in N}, let \eqn{N^i_{-}=\{j\in N:c_j<c_i}\} and let \eqn{N^i(c)\subseteq N} be defined by \eqn{N^i(c)=\{j\in N:c_j=c_i\}},
the sequential full contribution rule is defined by
\deqn{
\text{SFC}_i(c)=\frac{c_i-\text{max}\{c_j:j\in N^i_{-}\}}{|N_i(c)|}
}
According to this rule, an agent does not assist other agents with smaller needs than his own in
covering the costs they require, even though he uses the same segments they use (similarly, he does not receive any assistance
in covering his own segmental cost from agents with greater needs than his, even though these agents also use his segment).
If multiple agents have the same cost parameters, they equally share the cost of the common segment they use.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
SFCrule(c)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{PRIORrule}}, \code{\link{basicrule}}, \code{\link{weightedrule}}, \code{\link{hierarchicalrule}}
}
