% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSstructure.R
\name{NSstructure}
\alias{NSstructure}
\title{Composition of the no-subsidy set}
\usage{
NSstructure(cw, eta = rep(1, length(cw)))
}
\arguments{
\item{cw}{A numeric cost vector, with the same length as \code{eta}.}

\item{eta}{A numeric vector representing the size of each group of cloned agents. All its elements must be positive integers. By default, \code{eta = rep(1, length(cw))}, i.e.,
all groups have size 1.}
}
\value{
A list containing the following items:

\item{\code{n.faces}}{A positive integer representing the number of faces that form the NS set.}

\item{\code{n.full.dim.faces}}{A positive integer indicating the number of full-dimensional faces forming the NS set.}

\item{\code{n.extreme.points}}{A positive integer counting the number of extreme points of the NS set.}

\item{\code{actual.volume}}{A positive number representing the volume of the NS set.}

\item{\code{projected.volume}}{A positive number reflecting the projected volume of the NS set.}
}
\description{
\code{NSstructure} quantifies the key elements of the structure of the no-subsidy set.
}
\details{
For any cost vector \eqn{c}, if there are \eqn{n} agents with different cost parameters, the number of faces of the NS set is \eqn{2n-2}.
However, the number of full-dimensional faces is indeed affected by the presence of clones. Let \eqn{t\in N}, \eqn{(\eta,c)\in\mathcal{A}^N_t}, and
\eqn{\eta\ast c \in C^N}, \eqn{\text{NS}(\eta\ast c)} has \eqn{n+t-2} full-dimensional faces if \eqn{\eta_t=1} and \eqn{n+t-1} full-dimensional faces otherwise.
On the other hand, the number of different extreme points of the set \eqn{\text{NS}(\eta\ast c)} is: \eqn{\eta_t \prod_{i \in T \setminus \{t\}} (\eta_i + 1)}
(so, when there are no clones, the \eqn{\text{NS}(c)} has \eqn{2^{n-1}} extreme points).

Let \eqn{k\in\mathbb{N}} and denote by \eqn{\lambda_k} the \eqn{k}-dimensional Lebesgue measure. If \eqn{X=(X_1,\dots,X_k)} is a random vector
with joint density function \eqn{f} and \eqn{\Omega} is a Borel set, then \eqn{P(X\in\Omega)=\int_{\Omega}f(x)d\lambda_k}
and the expected value of \eqn{X} is \eqn{\mathbb{E}[X]=\int_{\mathbb{R}^k}x f(x)d\lambda_k}. Given a Borel set \eqn{\Omega\subset\mathbb{R}^k}
of positive measure, \eqn{\lambda_k(\Omega)>0}, we say that a random vector \eqn{U=(U_1,\dots,U_k)} has a uniform
distribution on \eqn{\Omega}, and we write \eqn{U\thicksim U(\Omega)}, if \eqn{U} has a probability density function \eqn{f(x_1,\dots,x_k)=\frac{1}{\lambda_k(\Omega)}} if
\eqn{(x_1,\dots, x_k)\in \Omega} and \eqn{f(x_1,\dots,x_k)=0} otherwise. If \eqn{a=(a_1,\dots,a_k)\in\mathbb{R}^k} with
\eqn{0<a_1\leq \dots \leq a_k}, denote
\deqn{
V_k(a)=\displaystyle\int_0^{a_1}\dots\displaystyle\int_0^{a_k-\sum\limits_{j=1}^{k-1} x_j}d x_k\dots d x_1.
}
Therefore, for each \eqn{c\in C^N}, the value \eqn{V_{n-1}(c_{-n})} is the
\eqn{(n-1)}-Lebesgue measure of \eqn{NS_n(c)}, so \eqn{\lambda_{n-1}(\text{NS}(c))=\sqrt{n}\lambda_{n-1}(\text{NS}_n(c))=\sqrt{n}V_{n-1}(c_{-n})}.
}
\examples{
# Without cloned agents
c <- c(1, 2, 3, 4)
NSstructure(c)

# With cloned agents
c <- c(1, 2)
eta <- c(3, 1)
NSstructure(c, eta)

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

González-Díaz, J., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2016). Airport games: the core and its center. \emph{Mathematical Social Sciences}, 82, 105–115.
}
\seealso{
\code{\link{NScheck}}, \code{\link{NSfaces}}, \code{\link{NSset}}, \code{\link{CCrule}}
}
