% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCrule.R
\name{CCrule}
\alias{CCrule}
\title{Core-center rule}
\usage{
CCrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{CCrule} calculates the contribution vector selected by the CC rule.
}
\details{
The core-center rule, CC, assigns to each \eqn{c\in C^N} the contribution vector given by the mean value of
\eqn{U(c)\thicksim U(\text{NS}(c))}, that is,
\deqn{
\text{CC}(c)=\mathbb{E}[U(\text{NS}(c))].
}
Therefore, this rule is the center of gravity of the set of allocations satisfying the no-subsidy constraints. It
coincides with the core-center of the cooperative game \eqn{v} associated with \eqn{c\in C^N}.
}
\note{
The execution time of the function may significantly increase if the number of agents exceeds 150.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
CCrule(c)

}
\references{
González-Díaz, J. and Sánchez-Rodríguez, E. (2007). A natural selection from the core of a TU game: the core-center.
\emph{International Journal of Game Theory}, 36, 27-26.

González-Díaz, J., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez (2015).
Monotonicity of the core-center of the airport game. \emph{TOP}, 23, 773-798.

González-Díaz, J., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez (2016).
Airport games: the core and its center. \emph{Mathematical Social Sciences}, 82, 105-115.
}
\seealso{
\code{\link{NSset}}, \code{\link{basicrule}}, \code{\link{clonesrule}} \code{\link{hierarchicalrule}}
}
