% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddiVortesFit.R
\name{plot.AddiVortesFit}
\alias{plot.AddiVortesFit}
\title{Plot Method for AddiVortesFit}
\usage{
\method{plot}{AddiVortesFit}(
  x,
  x_train,
  y_train,
  sigma_trace = NULL,
  which = c(1, 2, 3),
  ask = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{AddiVortesFit}, typically the result of a
call to \code{AddiVortes()}.}

\item{x_train}{A matrix of the original training covariates.}

\item{y_train}{A numeric vector of the original training true outcomes.}

\item{sigma_trace}{An optional numeric vector of sigma values from MCMC samples.
If not provided, the method will attempt to extract it from the model object.}

\item{which}{A numeric vector specifying which plots to generate:
1 = Residuals plot, 2 = Sigma trace, 3 = Tessellation complexity trace,
4 = Predicted vs Observed. Default is c(1, 2, 3).}

\item{ask}{Logical; if TRUE, the user is asked to press Enter before each plot.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
This function is called for its side effect of creating plots and returns
\code{NULL} invisibly.
}
\description{
Generates comprehensive diagnostic plots for a fitted \code{AddiVortesFit} object.
This function creates multiple diagnostic plots including residuals,
MCMC traces for sigma, and tessellation complexity over iterations.
}
\details{
The function generates up to four diagnostic plots:
\enumerate{
\item \strong{Residuals Plot}: Residuals vs fitted values with smoothed trend line
\item \strong{Sigma Trace}: MCMC trace plot for the error variance parameter
\item \strong{Tessellation Complexity}: Trace of average tessellation size over iterations
\item \strong{Predicted vs Observed}: Scatter plot with credible intervals
}
}
\examples{
\dontrun{
# Assuming 'fit' is a trained AddiVortesFit object
plot(fit, x_train = x_train_data, y_train = y_train_data)

# Show only specific plots
plot(fit, x_train = x_train_data, y_train = y_train_data, which = c(1, 3))

# With custom sigma trace
plot(fit, x_train = x_train_data, y_train = y_train_data, 
     sigma_trace = my_sigma_samples)
}
}
