% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk_logic.R
\name{AUKtest}
\alias{AUKtest}
\title{Calculate the AUK Estimator}
\usage{
AUKtest(data)
}
\arguments{
\item{data}{A matrix or data frame of observations where columns represent variables. 
Must contain at least 2 observations and 2 variables, with no missing values.}
}
\value{
A numeric value in the interval [0, 1] representing the AUK estimator.
}
\description{
Computes the Area Under the Kendall (AUK) estimator for multivariate independence. 
The AUK estimator is based on the survival copula and quantifies the deviation 
from the null hypothesis of independence.
}
\details{
The AUK estimator utilizes the empirical distribution function \eqn{F_n} and a 
generalized function \eqn{g(t)} to quantify independence in \eqn{d} dimensions. 
Under the null hypothesis of independence, the AUK value tends toward 0.5. 
The implementation includes numerical stability fixes for high-dimensional data.
}
\examples{
# Example 1: Independent Data
set.seed(123)
data_indep <- matrix(runif(300), 100, 3)
AUKtest(data_indep)

# Example 2: Dependent Data
x <- runif(100)
data_dep <- cbind(x, x^2, sqrt(x))
AUKtest(data_dep)

}
\references{
Afendras, G., Markatou, M., & Papantonis, N. (2025). AUK-based test for 
mutual independence and an index of mutual dependence. Journal of 
Multivariate Analysis, 105589. <doi:10.1016/j.jmva.2025.105589>
}
