% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_forc.r
\name{mat_forc}
\alias{mat_forc}
\title{mat_forc function
##############################################################################
NB: HERE WE USE Antolin-Diaz et al notation                                #
B is reduced form;                                                         #
A is structural;                                                           #
d is intercepts                                                            #
M is reduced so that E(u\emph{u')=Sigma=(A_0}A_0')^(-1) and M_0=A_0^(-1)*Q      #
Note that the code returns conflicting notation:                           #
B=>A_0^(-1)*Q and                                                          #
A=>B                                                                       #
##############################################################################}
\usage{
mat_forc(
  h = 1,
  n_draws,
  n_var,
  n_p,
  data_ = NULL,
  matrices = NULL,
  max_cores = 1
)
}
\arguments{
\item{h}{(integer) forecast horison}

\item{n_draws}{(integer) Number of draws}

\item{n_var}{(integer) Number of variables}

\item{n_p}{(integer) Number of lags}

\item{data_}{(matrix optional) The data, stacking Y over X (data and laggs)
-- columns are observations (default taken from matrices$Z)
NB: this is not necessarily the same as the data used to estimate the model
If run counterfactuals in previoius historical period (ie not forecast) must pass the data up to previous period relative to counterfactual}

\item{matrices}{Optional matrices object from gen_mats() (default taken from calling environment)}

\item{max_cores}{maximum number of cores to use for parallel processing (default: 1 for Windows compatibility)}
}
\value{
the big_b and big_M matrices of mean and IRF
}
\description{
mat_forc function
##############################################################################
NB: HERE WE USE Antolin-Diaz et al notation                                #
B is reduced form;                                                         #
A is structural;                                                           #
d is intercepts                                                            #
M is reduced so that E(u\emph{u')=Sigma=(A_0}A_0')^(-1) and M_0=A_0^(-1)*Q      #
Note that the code returns conflicting notation:                           #
B=>A_0^(-1)*Q and                                                          #
A=>B                                                                       #
##############################################################################
}
\examples{
\donttest{
library(APRScenario)
data(NKdata)

# Minimal example with a toy specification
spec <- bsvarSIGNs::specify_bsvarSIGN$new(as.matrix(NKdata[,2:4]), p = 1)
est <- bsvars::estimate(spec, S = 10)  # Use small S for fast test
matrices<-gen_mats(posterior = est, specification = spec)

# Example usage for matrix forecasting
result <- mat_forc(h = 4, n_draws = 10, n_var = 3, n_p = 1,
                   matrices = matrices)
}
}
