% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_mats.r
\name{gen_mats}
\alias{gen_mats}
\title{gen_mats function}
\usage{
gen_mats(posterior = NULL, specification = NULL, max_cores = 1)
}
\arguments{
\item{posterior}{Posterior estimation results (eg from BsvarSIGNs)}

\item{specification}{Optional specification object (default taken from calling environment)}

\item{max_cores}{maximum number of cores to use for parallel processing (default: 1 for Windows compatibility)}
}
\value{
Returns all objects necessary for scenario analysis (e.g., IRF matrix),
including: \code{M}, \code{M_inv}, \code{M_list}, \code{B}, \code{B_list},
\code{n_p}, \code{n_var}, \code{Y}, \code{X}, and \code{Z}.
}
\description{
this function returns the matrices necessary for forecasts
}
\examples{
\donttest{
library(APRScenario)
data(NKdata)

# Minimal example with a toy specification
spec <- bsvarSIGNs::specify_bsvarSIGN$new(as.matrix(NKdata[,2:4]), p = 1)
est <- bsvars::estimate(spec, S = 10)  # Use small S for fast test
gen_mats(posterior = est, specification = spec)
}
}
