% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_stress_sum.R
\name{calc_stress_sum}
\alias{calc_stress_sum}
\title{Calculate Perceived Stress Sum Score}
\usage{
calc_stress_sum(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `stress_sum`, where `stress_sum`
represents the total perceived stress score for each participant. Participants who did not answer all 10 questions will have NA values.
}
\description{
This function computes a numeric perceived stress score, which ranges from 0 to 40.
The score is the sum of responses to 10 specific items, where higher scores indicate higher levels of perceived stress.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 10),
  question_concept_id = rep(c(40192381, 40192396, 40192419, 40192445,
                              40192449, 40192452, 40192462, 40192491,
                              40192506, 40192525), times = 3),
  answer_concept_id = sample(c(40192465, 40192430, 40192429, 40192477,
                                40192424), 30, replace = TRUE)
)

# Compute perceived stress sum scores
stress_sum_scores <- calc_stress_sum(survey_df)
head(stress_sum_scores)

}
