% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hcd_count.R
\name{calc_hcd_count}
\alias{calc_hcd_count}
\title{Calculate Health Care Discrimination Count}
\usage{
calc_hcd_count(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `hcd_count`, where `hcd_count`
represents the number of health care discrimination items endorsed by the participant.
Participants who did not respond to all 7 items will have an NA value.
}
\description{
This function creates a numeric score (range 0-7) indicating how many items the participant endorsed
for perceived discrimination in health care. Higher scores indicate greater perceived discrimination
in health care settings.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 7),
  question_concept_id = rep(c(40192383, 40192394, 40192423, 40192425,
                              40192497, 40192503, 40192505), times = 3),
  answer_concept_id = sample(c(40192465, 40192481, 40192429, 40192382, 40192515),
                             21, replace = TRUE)
)

# Compute health care discrimination count
hcd_count_scores <- calc_hcd_count(survey_df)
head(hcd_count_scores)

}
