% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_english_proficient.R
\name{calc_english_proficient}
\alias{calc_english_proficient}
\title{Calculate English Proficiency Category}
\usage{
calc_english_proficient(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `english_proficient`, where `english_proficient`
categorizes participants as 'Proficient', 'Not proficient', or 'Unknown'. Participants who did not respond
will have an NA value for `english_proficient`.
}
\description{
This function creates a nominal categorical variable with values 'Proficient', 'Not proficient', or 'Unknown'
for participants who endorsed speaking a language other than English at home.
Proficient' refers to participants who reported speaking English 'Very well' or 'Well',
while 'Not proficient' refers to participants who reported speaking English 'Not well' or 'Not at all'.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 2, 3, 4, 5, 6, 7),
  question_concept_id = rep(40192529, 7),
  answer_concept_id = c(40192435, 40192510, 40192405, 40192387,
                        903087, 903079, NA)
)

# Compute English proficiency categories
english_proficient_scores <- calc_english_proficient(survey_df)
head(english_proficient_scores)

}
