% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-unitaryAlpha.R
\name{unitaryAlpha}
\alias{unitaryAlpha}
\title{unitary alpha}
\usage{
unitaryAlpha( m )
}
\arguments{
\item{m}{A data matrix for a group of observations.}
}
\value{
A measure of correlation between -1 and +1.
}
\description{
The function \code{unitaryAlpha()} computes
the unitary alpha (\insertCite{lc23}{ANOPA}). This
quantity is a novel way to compute correlation in a matrix
where each column is a measure and each line, a subject.
This measure is based on Cronbach's alpha (which could be
labeled a 'global alpha').
}
\details{
This measure is derived from Cronbach's measure of
reliability as shown by \insertCite{lc23;textual}{ANOPA}.
}
\examples{

# Generate a random matrix (here binary entries)
set.seed(42)
N <- M <- 10
m <- matrix( runif(N*M), N, M)

# compute the unitary alpha from that random matrix
unitaryAlpha(m)


}
\references{
\insertAllCited{}
}
