% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\name{compute_ph_y_mctq__sd_count}
\alias{compute_ph_y_mctq__sd_count}
\title{Compute "Munich Chronotype Questionnaire [Youth] (School Day): Count"}
\usage{
compute_ph_y_mctq__sd_count(data, name = "ph_y_mctq__sd_count", combine = TRUE)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the new column to be created (Default:
the name used in the ABCD data release).}

\item{combine}{logical. If TRUE, the new column will be bound to the input
data frame. If FALSE, the new column will be created as a new data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_y_mctq__sd_count}
Munich Chronotype Questionnaire [Youth] (School Day): Count
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_y_mctq__school_001}
\item \code{ph_y_mctq__school_001__01}
\item \code{ph_y_mctq__school_001__v01} (>= 7.0.0)
\item \code{ph_y_mctq__school_001__01__v1} (>= 7.0.0)
}
\item \emph{Excluded values:} none
}
}
\details{
In data release before 7.0 and 7.0.0 of the ABCDscores package,
the variables \code{ph_y_mctq__school_001__v01} and
\code{ph_y_mctq__school_001__01__v1} were
not available. In this case, the function will create
these variables internally and fill them with \code{NA} values.
After 7.0.0, these variables are expected to be present.
}
\examples{
\dontrun{
data <- compute_ph_y_mctq__sd_count(data)
select(
  data,
  any_of(c(
    "ph_y_mctq__school_001",
    "ph_y_mctq__school_001__01",
    "ph_y_mctq__school_001__v01",
    "ph_y_mctq__school_001__01__v1",
    "ph_y_mctq__sd_count"
  ))
)
}
}
