/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.X11Kernel;
import jdplus.x13.base.core.x11.extremevaluecorrector.IExtremeValuesCorrector;
import jdplus.x13.base.core.x11.filter.AutomaticHenderson;
import jdplus.x13.base.core.x11.filter.DefaultSeasonalNormalizer;
import jdplus.x13.base.core.x11.filter.DummyFilter;
import jdplus.x13.base.core.x11.filter.MusgraveFilterFactory;
import jdplus.x13.base.core.x11.filter.X11SeasonalFilterProcessor;
import jdplus.x13.base.core.x11.filter.X11SeasonalFiltersFactory;
import jdplus.x13.base.core.x11.filter.X11TrendCycleFilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.AsymmetricEndPoints;
import lombok.Generated;

public class X11BStep {
    private DoubleSeq b1;
    private DoubleSeq b2;
    private DoubleSeq b3;
    private DoubleSeq b4;
    private DoubleSeq b4a;
    private DoubleSeq b4anorm;
    private DoubleSeq b4d;
    private DoubleSeq b4g;
    private DoubleSeq b5;
    private DoubleSeq b6;
    private DoubleSeq b7;
    private DoubleSeq b8;
    private DoubleSeq b9;
    private DoubleSeq b9g;
    private DoubleSeq b10;
    private DoubleSeq b11;
    private DoubleSeq b13;
    private DoubleSeq b17;
    private DoubleSeq b20;
    private int b2drop;

    public void process(DoubleSeq input, X11Context context) {
        this.b1 = input;
        this.b2Step(context);
        this.b3Step(context);
        this.b4Step(context);
        this.b5Step(context);
        this.b6Step(context);
        this.b7Step(context);
        this.b8Step(context);
        this.b9Step(context);
        this.bFinalStep(context);
    }

    private void b2Step(X11Context context) {
        SymmetricFilter filter = X11TrendCycleFilterFactory.makeTrendFilter(context.getPeriod());
        this.b2drop = filter.length() / 2;
        double[] x = X11Kernel.table(this.b1.length() - 2 * this.b2drop, Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)0, (int)x.length);
        filter.apply(this.b1, (DoubleSeq.Mutable)out);
        this.b2 = DoubleSeq.of((double[])x);
    }

    private void b3Step(X11Context context) {
        this.b3 = context.remove(this.b1.drop(this.b2drop, this.b2drop), this.b2);
    }

    private void b4Step(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getInitialSeasonalFilter());
            this.b4a = processor.process(this.b3, context.getPosition(this.b2drop));
            this.b4anorm = DefaultSeasonalNormalizer.normalize(this.b4a, 0, context, this.b2drop);
        } else {
            this.b4anorm = this.b4a = DummyFilter.filter(context.isMultiplicative(), this.b3);
        }
        this.b4d = this.b4d(context);
        IExtremeValuesCorrector ecorr = context.selectExtremeValuesCorrector(this.b4d);
        int j = context.getPosition(this.b2drop);
        ecorr.analyse(this.b4d, j, context);
        this.b4 = ecorr.computeCorrections(this.b3, false);
        this.b4g = ecorr.applyCorrections(this.b3, this.b4);
    }

    protected DoubleSeq b4d(X11Context context) {
        return context.remove(this.b3, this.b4anorm);
    }

    private void b5Step(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getInitialSeasonalFilter());
            DoubleSeq b5a = processor.process(this.b4g, context.getPosition(this.b2drop));
            this.b5 = DefaultSeasonalNormalizer.normalize(b5a, this.b2drop, context);
        } else {
            this.b5 = DummyFilter.filter(context.isMultiplicative(), this.b4g);
        }
    }

    private void b6Step(X11Context context) {
        this.b6 = this.b6(context);
    }

    protected DoubleSeq b6(X11Context context) {
        return context.remove(this.b1, this.b5);
    }

    private void b7Step(X11Context context) {
        SymmetricFilter filter;
        if (context.isAutomaticHenderson()) {
            double icr = AutomaticHenderson.calcICR(context, this.b6);
            int filterLength = icr >= 1.0 && context.getPeriod() != 2 ? context.getPeriod() + 1 : AutomaticHenderson.selectFilter(icr, context.getPeriod());
            filter = context.trendFilter(filterLength);
        } else {
            filter = context.trendFilter();
        }
        int ndrop = filter.length() / 2;
        double[] x = X11Kernel.table(this.b6.length(), Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        filter.apply(this.b6, (DoubleSeq.Mutable)out);
        double r = MusgraveFilterFactory.findR(filter.length(), context.getPeriod());
        IFiniteFilter[] asymmetricFilter = context.asymmetricTrendFilters(filter, r);
        AsymmetricEndPoints aep = new AsymmetricEndPoints(asymmetricFilter, 0);
        aep.process(this.b6, DataBlock.of((double[])x));
        this.b7 = DoubleSeq.of((double[])x);
        if (context.isMultiplicative()) {
            this.b7 = X11Context.makePositivity(this.b7);
        }
    }

    private void b8Step(X11Context context) {
        this.b8 = context.remove(this.b1, this.b7);
    }

    private void b9Step(X11Context context) {
        DoubleSeq b9c;
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getFinalSeasonalFilter());
            DoubleSeq b9a = processor.process(this.b8, context.getPosition(0));
            b9c = DefaultSeasonalNormalizer.normalize(b9a, 0, context);
        } else {
            b9c = DummyFilter.filter(context.isMultiplicative(), this.b8);
        }
        DoubleSeq b9d = this.b9d(context, b9c);
        IExtremeValuesCorrector ecorr = context.getExtremeValuesCorrector();
        ecorr.analyse(b9d, context.getPosition(0), context);
        this.b9 = ecorr.computeCorrections(this.b8, false);
        this.b9g = ecorr.applyCorrections(this.b8, this.b9);
    }

    protected DoubleSeq b9d(X11Context context, DoubleSeq b9c) {
        return context.remove(this.b8, b9c);
    }

    private void bFinalStep(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getFinalSeasonalFilter());
            DoubleSeq b10a = processor.process(this.b9g, context.getPosition(0));
            this.b10 = DefaultSeasonalNormalizer.normalize(b10a, 0, context);
        } else {
            this.b10 = DummyFilter.filter(context.isMultiplicative(), this.b9g);
        }
        this.b11 = this.b11(context);
        this.b13 = context.remove(this.b11, this.b7);
        IExtremeValuesCorrector ecorr = context.selectExtremeValuesCorrector(this.b13);
        ecorr.analyse(this.b13, context.getPosition(0), context);
        this.b17 = ecorr.getObservationWeights();
        this.b20 = ecorr.getCorrectionFactors();
    }

    protected DoubleSeq b11(X11Context context) {
        return context.remove(this.b1, this.b10);
    }

    @Generated
    public DoubleSeq getB1() {
        return this.b1;
    }

    @Generated
    public DoubleSeq getB2() {
        return this.b2;
    }

    @Generated
    public DoubleSeq getB3() {
        return this.b3;
    }

    @Generated
    public DoubleSeq getB4() {
        return this.b4;
    }

    @Generated
    public DoubleSeq getB4a() {
        return this.b4a;
    }

    @Generated
    public DoubleSeq getB4anorm() {
        return this.b4anorm;
    }

    @Generated
    public DoubleSeq getB4d() {
        return this.b4d;
    }

    @Generated
    public DoubleSeq getB4g() {
        return this.b4g;
    }

    @Generated
    public DoubleSeq getB5() {
        return this.b5;
    }

    @Generated
    public DoubleSeq getB6() {
        return this.b6;
    }

    @Generated
    public DoubleSeq getB7() {
        return this.b7;
    }

    @Generated
    public DoubleSeq getB8() {
        return this.b8;
    }

    @Generated
    public DoubleSeq getB9() {
        return this.b9;
    }

    @Generated
    public DoubleSeq getB9g() {
        return this.b9g;
    }

    @Generated
    public DoubleSeq getB10() {
        return this.b10;
    }

    @Generated
    public DoubleSeq getB11() {
        return this.b11;
    }

    @Generated
    public DoubleSeq getB13() {
        return this.b13;
    }

    @Generated
    public DoubleSeq getB17() {
        return this.b17;
    }

    @Generated
    public DoubleSeq getB20() {
        return this.b20;
    }

    @Generated
    public int getB2drop() {
        return this.b2drop;
    }
}

