/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x13;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.processing.GenericResults;
import jdplus.toolkit.base.api.processing.ProcResults;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.x13.base.api.x13.X13Exception;
import jdplus.x13.base.api.x13.X13Loader;
import jdplus.x13.base.api.x13.X13Spec;
import lombok.Generated;

public final class X13 {
    private static final X13Loader.Processor ENGINE = new X13Loader.Processor();
    private static final AtomicReference<Processor> LEGACYENGINE = new AtomicReference();

    public static void setEngine(Processor algorithm) {
        ENGINE.set(algorithm);
    }

    public static Processor getEngine() {
        return ENGINE.get();
    }

    public static ProcResults process(TsData series, X13Spec spec, ModellingContext context, List<String> items) {
        return ENGINE.get().process(series, spec, context, items);
    }

    public static Map<String, Class> outputDictionary(boolean compact) {
        return ENGINE.get().outputDictionary(compact);
    }

    public static void setLegacyEngine(Processor algorithm) {
        LEGACYENGINE.set(algorithm);
    }

    public static Processor getLegacyEngine() {
        return LEGACYENGINE.get();
    }

    public static ProcResults processLegacy(TsData series, X13Spec spec, ModellingContext context, List<String> items) {
        Processor cp = LEGACYENGINE.get();
        if (cp == null) {
            throw new X13Exception("No legacy engine");
        }
        return cp.process(series, spec, context, items);
    }

    @Generated
    private X13() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor {
        public ProcResults process(TsData var1, X13Spec var2, ModellingContext var3, List<String> var4);

        public Map<String, Class> outputDictionary(boolean var1);
    }

    public static final class DefProcessor
    implements Processor {
        @Override
        public ProcResults process(TsData series, X13Spec spec, ModellingContext context, List<String> items) {
            return GenericResults.notImplemented();
        }

        @Override
        public Map<String, Class> outputDictionary(boolean compact) {
            return Collections.emptyMap();
        }
    }
}

