/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.protobuf;

import jdplus.tramoseats.base.api.tramo.EasterSpec;
import jdplus.tramoseats.base.api.tramo.RegressionTestType;
import jdplus.tramoseats.base.api.tramo.TradingDaysSpec;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;
import jdplus.tramoseats.base.protobuf.AutomaticTradingDays;
import jdplus.tramoseats.base.protobuf.EasterType;
import jdplus.tramoseats.base.protobuf.SpecProto;
import jdplus.tramoseats.base.protobuf.TradingDaysTest;
import jdplus.tramoseats.base.protobuf.TramoSeatsOutput;
import jdplus.tramoseats.base.protobuf.TramoSeatsResultsProto;
import lombok.Generated;

public final class TramoSeatsProtosUtility {
    public static EasterSpec.Type convert(EasterType type) {
        switch (type) {
            case EASTER_STANDARD: {
                return EasterSpec.Type.Standard;
            }
            case EASTER_INCLUDEEASTER: {
                return EasterSpec.Type.IncludeEaster;
            }
            case EASTER_INCLUDEEASTERMONDAY: {
                return EasterSpec.Type.IncludeEasterMonday;
            }
        }
        return EasterSpec.Type.Unused;
    }

    public static EasterType convert(EasterSpec.Type type) {
        switch (type) {
            case Standard: {
                return EasterType.EASTER_STANDARD;
            }
            case IncludeEaster: {
                return EasterType.EASTER_INCLUDEEASTER;
            }
            case IncludeEasterMonday: {
                return EasterType.EASTER_INCLUDEEASTERMONDAY;
            }
        }
        return EasterType.EASTER_UNUSED;
    }

    public static TradingDaysTest convert(RegressionTestType test) {
        switch (test) {
            case Joint_F: {
                return TradingDaysTest.TD_TEST_JOINT_F;
            }
            case Separate_T: {
                return TradingDaysTest.TD_TEST_SEPARATE_T;
            }
        }
        return TradingDaysTest.TD_TEST_NO;
    }

    public static RegressionTestType convert(TradingDaysTest test) {
        switch (test) {
            case TD_TEST_JOINT_F: {
                return RegressionTestType.Joint_F;
            }
            case TD_TEST_SEPARATE_T: {
                return RegressionTestType.Separate_T;
            }
        }
        return RegressionTestType.None;
    }

    public static AutomaticTradingDays convert(TradingDaysSpec.AutoMethod auto) {
        switch (auto) {
            case FTEST: {
                return AutomaticTradingDays.TD_AUTO_FTEST;
            }
            case WALD: {
                return AutomaticTradingDays.TD_AUTO_WALD;
            }
            case BIC: {
                return AutomaticTradingDays.TD_AUTO_BIC;
            }
            case AIC: {
                return AutomaticTradingDays.TD_AUTO_AIC;
            }
        }
        return AutomaticTradingDays.TD_AUTO_NO;
    }

    public static TradingDaysSpec.AutoMethod convert(AutomaticTradingDays auto) {
        return switch (auto) {
            case AutomaticTradingDays.TD_AUTO_FTEST -> TradingDaysSpec.AutoMethod.FTEST;
            case AutomaticTradingDays.TD_AUTO_WALD -> TradingDaysSpec.AutoMethod.WALD;
            case AutomaticTradingDays.TD_AUTO_BIC -> TradingDaysSpec.AutoMethod.BIC;
            case AutomaticTradingDays.TD_AUTO_AIC -> TradingDaysSpec.AutoMethod.AIC;
            default -> TradingDaysSpec.AutoMethod.UNUSED;
        };
    }

    public static TramoSeatsOutput convert(jdplus.tramoseats.base.core.tramoseats.TramoSeatsOutput output) {
        TramoSeatsOutput.Builder builder = TramoSeatsOutput.newBuilder().setEstimationSpec(SpecProto.convert(output.getEstimationSpec()));
        TramoSeatsResults result = output.getResult();
        if (result != null && result.isValid()) {
            builder.setResult(TramoSeatsResultsProto.convert(result)).setResultSpec(SpecProto.convert(output.getResultSpec()));
        }
        return builder.build();
    }

    @Generated
    private TramoSeatsProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

