/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import java.time.LocalDate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class ChangeOfRegimeSpec {
    private final LocalDate date;
    private final Type type;

    public ChangeOfRegimeSpec(LocalDate date) {
        this.date = date;
        this.type = Type.Full;
    }

    public ChangeOfRegimeSpec(LocalDate day, Type type) {
        this.date = day;
        this.type = type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        if (this.type == Type.Partial_ZeroStart) {
            builder.append('/');
        }
        builder.append(this.date);
        if (this.type == Type.Partial_ZeroEnd) {
            builder.append('/');
        }
        builder.append('/');
        return builder.toString();
    }

    public static ChangeOfRegimeSpec fromString(String s) {
        Type type;
        int beg = 0;
        int end = s.length();
        if (end < 3 || s.charAt(beg) != '/' || s.charAt(end - 1) != '/') {
            return null;
        }
        --end;
        if (s.charAt(++beg) == '/') {
            ++beg;
            type = Type.Partial_ZeroStart;
        } else if (s.charAt(end - 1) == '/') {
            --end;
            type = Type.Partial_ZeroEnd;
        } else {
            type = Type.Full;
        }
        LocalDate day = LocalDate.parse(s.substring(beg, end));
        if (day == null) {
            return null;
        }
        return new ChangeOfRegimeSpec(day, type);
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeOfRegimeSpec)) {
            return false;
        }
        ChangeOfRegimeSpec other = (ChangeOfRegimeSpec)o;
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum Type {
        Full,
        Partial_ZeroStart,
        Partial_ZeroEnd;

    }
}

