/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import internal.toolkit.base.api.timeseries.util.TsDataBuilderUtil;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Ts {
    public static final String SOURCE_OLD = "tsmoniker.source";
    public static final String ID_OLD = "tsmoniker.id";
    public static final String DYNAMIC = "dynamic";
    public static final String BEG = "@beg";
    public static final String END = "@end";
    public static final String CONFIDENTIAL = "@confidential";
    @NonNull
    private final TsMoniker moniker;
    @NonNull
    private final TsInformationType type;
    @NonNull
    private final String name;
    private final Map<String, String> meta;
    @NonNull
    private final TsData data;
    private static final String FROZEN = " (frozen)";

    public static Builder builder() {
        return new Builder().moniker(TsMoniker.NULL).type(TsInformationType.UserDefined).name("").data(TsDataBuilderUtil.NO_DATA);
    }

    @NonNull
    public static Ts of(@NonNull TsData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Ts.builder().moniker(TsMoniker.of()).data(data).build();
    }

    @NonNull
    public static Ts of(@NonNull String name, @NonNull TsData data) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Ts.builder().moniker(TsMoniker.of()).name(name).data(data).build();
    }

    @NonNull
    public Ts load(@NonNull TsInformationType info, @NonNull TsFactory factory) {
        Objects.requireNonNull(info);
        Objects.requireNonNull(factory);
        if (this.type.encompass(info)) {
            return this;
        }
        if (!this.moniker.isProvided()) {
            return this;
        }
        return factory.makeTs(this.moniker, info);
    }

    @NonNull
    public Ts freeze() {
        if (!this.moniker.isProvided()) {
            return this;
        }
        Builder builder = this.toBuilder();
        Ts.putFreezeMeta(builder, this.moniker);
        return builder.moniker(TsMoniker.of()).name(this.name + FROZEN).type(TsInformationType.UserDefined).build();
    }

    @NonNull
    public Ts unfreeze(@NonNull TsFactory factory, TsInformationType type) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (this.moniker.isProvided()) {
            return this;
        }
        TsMoniker pmoniker = Ts.getFreezeMeta(this.meta);
        if (pmoniker == null) {
            return this;
        }
        return factory.makeTs(pmoniker, type);
    }

    private static void putFreezeMeta(@NonNull Builder builder, @NonNull TsMoniker origin) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        builder.meta("@source", origin.getSource());
        builder.meta("@id", origin.getId());
        builder.meta("@timestamp", LocalDateTime.now(Clock.systemDefaultZone()).format(DateTimeFormatter.ISO_DATE));
    }

    private static boolean containsFreezeMeta(@NonNull Map<String, String> md) {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        if (md.containsKey("@source")) {
            return true;
        }
        return md.containsKey(SOURCE_OLD);
    }

    private static @Nullable TsMoniker getFreezeMeta(@NonNull Map<String, String> md) {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        String source = md.get("@source");
        if (source == null) {
            source = md.get(SOURCE_OLD);
        }
        if (source == null) {
            return null;
        }
        if (source.length() == 0) {
            return TsMoniker.of();
        }
        if (DYNAMIC.equals(source)) {
            return TsMoniker.of();
        }
        String id = md.get("@id");
        if (id == null) {
            id = md.get(ID_OLD);
        }
        if (id == null) {
            return null;
        }
        return TsMoniker.of(source, id);
    }

    public boolean isFrozen() {
        if (this.moniker.isProvided()) {
            return false;
        }
        TsMoniker pmoniker = Ts.getFreezeMeta(this.meta);
        return pmoniker != null;
    }

    @Generated
    Ts(@NonNull TsMoniker moniker, @NonNull TsInformationType type, @NonNull String name, Map<String, String> meta, @NonNull TsData data) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.moniker = moniker;
        this.type = type;
        this.name = name;
        this.meta = meta;
        this.data = data;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().moniker(this.moniker).type(this.type).name(this.name).data(this.data);
        if (this.meta != null) {
            builder.meta(this.meta);
        }
        return builder;
    }

    @NonNull
    @Generated
    public TsMoniker getMoniker() {
        return this.moniker;
    }

    @NonNull
    @Generated
    public TsInformationType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @NonNull
    @Generated
    public TsData getData() {
        return this.data;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ts)) {
            return false;
        }
        Ts other = (Ts)o;
        TsMoniker this$moniker = this.getMoniker();
        TsMoniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !((Object)this$moniker).equals(other$moniker)) {
            return false;
        }
        TsInformationType this$type = this.getType();
        TsInformationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$meta = this.getMeta();
        Map<String, String> other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        TsData this$data = this.getData();
        TsData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TsMoniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : ((Object)$moniker).hashCode());
        TsInformationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        TsData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "Ts(moniker=" + String.valueOf(this.getMoniker()) + ", type=" + String.valueOf((Object)this.getType()) + ", name=" + this.getName() + ", meta=" + String.valueOf(this.getMeta()) + ", data=" + String.valueOf(this.getData()) + ")";
    }

    @Generated
    public @org.jspecify.annotations.NonNull Ts withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new Ts(this.moniker, this.type, name, this.meta, this.data);
    }

    @Generated
    public static class Builder {
        @Generated
        private TsMoniker moniker;
        @Generated
        private TsInformationType type;
        @Generated
        private String name;
        @Generated
        private ArrayList<String> meta$key;
        @Generated
        private ArrayList<String> meta$value;
        @Generated
        private TsData data;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder moniker(@NonNull TsMoniker moniker) {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.moniker = moniker;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(@NonNull TsInformationType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(String metaKey, String metaValue) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            this.meta$key.add(metaKey);
            this.meta$value.add(metaValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> meta) {
            if (meta == null) {
                throw new NullPointerException("meta cannot be null");
            }
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : meta.entrySet()) {
                this.meta$key.add($lombokEntry.getKey());
                this.meta$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearMeta() {
            if (this.meta$key != null) {
                this.meta$key.clear();
                this.meta$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder data(@NonNull TsData data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Ts build() {
            Map<String, String> meta;
            switch (this.meta$key == null ? 0 : this.meta$key.size()) {
                case 0: {
                    meta = Collections.emptyMap();
                    break;
                }
                case 1: {
                    meta = Collections.singletonMap(this.meta$key.get(0), this.meta$value.get(0));
                    break;
                }
                default: {
                    meta = new LinkedHashMap(this.meta$key.size() < 0x40000000 ? 1 + this.meta$key.size() + (this.meta$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.meta$key.size(); ++$i) {
                        meta.put(this.meta$key.get($i), this.meta$value.get($i));
                    }
                    meta = Collections.unmodifiableMap(meta);
                }
            }
            return new Ts(this.moniker, this.type, this.name, meta, this.data);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "Ts.Builder(moniker=" + String.valueOf(this.moniker) + ", type=" + String.valueOf((Object)this.type) + ", name=" + this.name + ", meta$key=" + String.valueOf(this.meta$key) + ", meta$value=" + String.valueOf(this.meta$value) + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

