/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.legacy;

import java.io.File;
import java.nio.file.Path;
import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.legacy.LegacyId;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

@DemetraPlusLegacy
public final class LegacyFileId
implements CharSequence {
    private final String file;

    public static @Nullable LegacyFileId of(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return LegacyFileId.parse(file.getAbsolutePath());
    }

    public static @Nullable LegacyFileId parse(@NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return input instanceof LegacyFileId ? (LegacyFileId)input : LegacyFileId.parse(input.toString());
    }

    public static @Nullable LegacyFileId parse(@NonNull String input) {
        LegacyId id;
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (!LegacyFileId.isDemetraUri(input) && (id = LegacyId.parse(LegacyId.Handler.PLAIN, input)) != null && id.getCount() == 1 && LegacyFileId.isValidPath(Path.of(id.get(0), new String[0]).toFile())) {
            return new LegacyFileId(id.get(0));
        }
        return null;
    }

    private LegacyFileId(String file) {
        this.file = file;
    }

    @Override
    public String toString() {
        return this.file;
    }

    @Override
    public int length() {
        return this.file.length();
    }

    @Override
    public char charAt(int index) {
        return this.file.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.file.subSequence(start, end);
    }

    public DataSource toDataSource(@NonNull String providerName, @NonNull String version) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return DataSource.of(providerName, version, "file", this.file);
    }

    @NonNull
    public static Parser<DataSource> asDataSourceParser(@NonNull String providerName, @NonNull String version) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return o -> LegacyFileId.getDataSource(o, providerName, version);
    }

    private static boolean isDemetraUri(String input) {
        return input.startsWith("demetra://");
    }

    private static DataSource getDataSource(CharSequence o, String providerName, String version) {
        LegacyFileId id = LegacyFileId.parse(o);
        return id != null ? id.toDataSource(providerName, version) : null;
    }

    @Deprecated
    private static boolean isValidPath(File file) {
        try {
            file.getCanonicalPath();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Generated
    public String getFile() {
        return this.file;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacyFileId)) {
            return false;
        }
        LegacyFileId other = (LegacyFileId)o;
        String this$file = this.getFile();
        String other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }
}

