/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.cube;

import internal.toolkit.base.tsp.cube.CubeRepository;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import jdplus.toolkit.base.tsp.cube.BulkCube;
import jdplus.toolkit.base.tsp.cube.CubeConnection;
import jdplus.toolkit.base.tsp.cube.CubeId;
import jdplus.toolkit.base.tsp.cube.CubeSeries;
import jdplus.toolkit.base.tsp.cube.CubeSeriesWithData;
import jdplus.toolkit.base.tsp.cube.HasCubeId;
import jdplus.toolkit.base.tsp.util.ShortLivedCache;
import jdplus.toolkit.base.tsp.util.ShortLivedCaching;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.IOIterator;
import nbbrd.io.Resource;
import nbbrd.io.function.IORunnable;
import org.jspecify.annotations.Nullable;

public final class BulkCubeConnection
implements CubeConnection {
    @NonNull
    private final CubeConnection delegate;
    private final int depth;
    @NonNull
    private final ShortLivedCache<CubeId, List<CubeSeriesWithData>> cache;

    @NonNull
    public static CubeConnection of(@NonNull CubeConnection delegate, @NonNull BulkCube options, @NonNull ShortLivedCaching cacheFactory) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked non-null but is null");
        }
        return options.isCacheEnabled() ? new BulkCubeConnection(delegate, options.getDepth(), cacheFactory.ofTtl(options.getTtl())) : delegate;
    }

    private int getCacheLevel() throws IOException {
        return Math.max(0, this.delegate.getRoot().getMaxLevel() - this.depth);
    }

    @Override
    @NonNull
    public Stream<CubeId> getChildren(@NonNull CubeId node) throws IOException {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        CubeRepository.checkNode(node);
        List<CubeSeriesWithData> list = this.peekList(node);
        if (list != null) {
            return list.stream().map(HasCubeId::getId).filter(node::isAncestorOf).map(node.getDepth() == 1 ? item -> item : item -> item.getAncestor(node.getLevel() + 1)).filter(Objects::nonNull).distinct();
        }
        return this.delegate.getChildren(node);
    }

    @Override
    @NonNull
    public Optional<CubeSeries> getSeries(@NonNull CubeId leaf) throws IOException {
        if (leaf == null) {
            throw new NullPointerException("leaf is marked non-null but is null");
        }
        CubeRepository.checkLeaf(leaf);
        List<CubeSeriesWithData> list = this.peekList(leaf);
        if (list != null) {
            return list.stream().filter(BulkCubeConnection.onIdEqualTo(leaf)).map(CubeSeriesWithData::withoutData).findFirst();
        }
        return this.delegate.getSeries(leaf);
    }

    @Override
    @NonNull
    public Stream<CubeSeries> getAllSeries(@NonNull CubeId node) throws IOException {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        CubeRepository.checkNode(node);
        List<CubeSeriesWithData> list = this.peekList(node);
        if (list != null) {
            return list.stream().filter(BulkCubeConnection.onIdDescendantOf(node)).map(CubeSeriesWithData::withoutData);
        }
        return this.delegate.getAllSeries(node);
    }

    @Override
    @NonNull
    public Optional<CubeSeriesWithData> getSeriesWithData(@NonNull CubeId leaf) throws IOException {
        if (leaf == null) {
            throw new NullPointerException("leaf is marked non-null but is null");
        }
        CubeRepository.checkLeaf(leaf);
        try (Stream<CubeSeriesWithData> stream = this.getCloseableStream(leaf);){
            Optional<HasCubeId> optional = stream.filter(BulkCubeConnection.onIdEqualTo(leaf)).findFirst();
            return optional;
        }
    }

    @Override
    @NonNull
    public Stream<CubeSeriesWithData> getAllSeriesWithData(@NonNull CubeId node) throws IOException {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        CubeRepository.checkNode(node);
        return this.getCloseableStream(node).filter(BulkCubeConnection.onIdDescendantOf(node));
    }

    @Override
    @NonNull
    public Optional<IOException> testConnection() {
        return this.delegate.testConnection();
    }

    @Override
    @NonNull
    public CubeId getRoot() throws IOException {
        return this.delegate.getRoot();
    }

    @Override
    @NonNull
    public String getDisplayName() throws IOException {
        return this.delegate.getDisplayName();
    }

    @Override
    @NonNull
    public String getDisplayName(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.delegate.getDisplayName(id);
    }

    @Override
    @NonNull
    public String getDisplayNodeName(@NonNull CubeId id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.delegate.getDisplayNodeName(id);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private @Nullable List<CubeSeriesWithData> peekList(@NonNull CubeId nodeOrLeaf) throws IOException {
        if (nodeOrLeaf == null) {
            throw new NullPointerException("nodeOrLeaf is marked non-null but is null");
        }
        int cacheLevel = this.getCacheLevel();
        if (nodeOrLeaf.getLevel() == cacheLevel) {
            return this.cache.get(nodeOrLeaf);
        }
        CubeId ancestor = nodeOrLeaf.getAncestor(cacheLevel);
        if (ancestor != null) {
            return this.cache.get(ancestor);
        }
        return null;
    }

    @NonNull
    private Stream<CubeSeriesWithData> getCloseableStream(@NonNull CubeId nodeOrLeaf) throws IOException {
        if (nodeOrLeaf == null) {
            throw new NullPointerException("nodeOrLeaf is marked non-null but is null");
        }
        int cacheLevel = this.getCacheLevel();
        if (nodeOrLeaf.getLevel() == cacheLevel) {
            return this.getOrLoad(nodeOrLeaf);
        }
        CubeId ancestor = nodeOrLeaf.getAncestor(cacheLevel);
        if (ancestor != null) {
            return this.getOrLoad(ancestor);
        }
        return this.load(nodeOrLeaf);
    }

    @NonNull
    private Stream<CubeSeriesWithData> load(@NonNull CubeId nodeOrLeaf) throws IOException {
        if (nodeOrLeaf == null) {
            throw new NullPointerException("nodeOrLeaf is marked non-null but is null");
        }
        return nodeOrLeaf.isSeries() ? this.delegate.getSeriesWithData(nodeOrLeaf).stream() : this.delegate.getAllSeriesWithData(nodeOrLeaf);
    }

    @NonNull
    private Stream<CubeSeriesWithData> getOrLoad(@NonNull CubeId nodeOrLeaf) throws IOException {
        if (nodeOrLeaf == null) {
            throw new NullPointerException("nodeOrLeaf is marked non-null but is null");
        }
        List<CubeSeriesWithData> result = this.cache.get(nodeOrLeaf);
        if (result != null) {
            return result.stream();
        }
        Stream<CubeSeriesWithData> closeableStream = this.load(nodeOrLeaf);
        IOIterator iterator = IOIterator.checked(closeableStream.iterator());
        return new CachingIterator(nodeOrLeaf, this.cache, (IOIterator<CubeSeriesWithData>)iterator, closeableStream::close).asStream();
    }

    private static Predicate<HasCubeId> onIdEqualTo(CubeId leaf) {
        return ts -> leaf.equals((Object)ts.getId());
    }

    private static Predicate<HasCubeId> onIdDescendantOf(CubeId node) {
        return ts -> node.isAncestorOf(ts.getId());
    }

    @Generated
    BulkCubeConnection(@NonNull CubeConnection delegate, int depth, @NonNull ShortLivedCache<CubeId, List<CubeSeriesWithData>> cache) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        this.delegate = delegate;
        this.depth = depth;
        this.cache = cache;
    }

    private static final class CachingIterator
    implements IOIterator<CubeSeriesWithData>,
    Closeable {
        private final CubeId key;
        private final ShortLivedCache<CubeId, List<CubeSeriesWithData>> cache;
        private final IOIterator<CubeSeriesWithData> delegate;
        private final Closeable closeable;
        private final List<CubeSeriesWithData> items = new ArrayList<CubeSeriesWithData>();

        public boolean hasNextWithIO() throws IOException {
            return this.delegate.hasNextWithIO();
        }

        public CubeSeriesWithData nextWithIO() throws IOException, NoSuchElementException {
            CubeSeriesWithData result = (CubeSeriesWithData)this.delegate.nextWithIO();
            this.items.add(result);
            return result;
        }

        @NonNull
        public Stream<CubeSeriesWithData> asStream() {
            return (Stream)super.asStream().onClose(IORunnable.unchecked(this::close));
        }

        @Override
        public void close() throws IOException {
            Resource.closeBoth(this::flushToCache, (Closeable)this.closeable);
        }

        private void flushToCache() throws IOException {
            while (this.hasNextWithIO()) {
                this.nextWithIO();
            }
            this.cache.put(this.key, this.items);
        }

        @Generated
        public CachingIterator(CubeId key, ShortLivedCache<CubeId, List<CubeSeriesWithData>> cache, IOIterator<CubeSeriesWithData> delegate, Closeable closeable) {
            this.key = key;
            this.cache = cache;
            this.delegate = delegate;
            this.closeable = closeable;
        }
    }
}

