EVAL <- isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) &&
  requireNamespace("terra", quietly = TRUE) &&
  rgeedim::gd_is_initialized(project = Sys.getenv("GOOGLE_CLOUD_QUOTA_PROJECT", "rgeedim-demo"))

litedown::reactor(
  eval = EVAL,
  collapse = TRUE,
  fig.width = 8,
  fig.align = 'center'
)

library(rgeedim)
library(terra)

project_id <- Sys.getenv("GOOGLE_CLOUD_QUOTA_PROJECT", "rgeedim-demo")
gd_initialize(project = project_id)

ee <- earthengine()

p <- ee$FeatureCollection("WCMC/WDPA/current/polygons")$filter(
  ee$Filter$And(
    ee$Filter$eq("NAME", "Yellowstone"),
    ee$Filter$eq("DESIG_ENG", "National Park")
  )
)

y <- gd_region(p) |> 
  gd_region_to_vect()

b <- gd_bbox(p) |> 
  gd_region() |> 
  gd_region_to_vect()

r <- gd_image_from_id("USGS/SRTMGL1_003") |> 
  gd_download(
    "dem.tif",
    region = b,
    overwrite = TRUE,
    resampling = "bilinear",
    scale = 100, 
    crs = "EPSG:4326",
    bands = list("elevation")
  ) |>
  terra::rast()

plot(r)
plot(as.lines(y), add = TRUE, col = "red", lwd = 3)

unlink("dem.tif")

