% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_network}
\alias{plot_network}
\title{Plot interactive \pkg{visNetwork} visualisation of object-relationship
network of package.}
\usage{
plot_network(s, plot = TRUE, vis_save = NULL)
}
\arguments{
\item{s}{Package statistics obtained from \link{pkgstats} function.}

\item{plot}{If \code{TRUE}, plot the network using \pkg{visNetwork} which opens an
interactive browser pane.}

\item{vis_save}{Name of local file in which to save \code{html} file of network
visualisation (will override \code{plot} to \code{FALSE}).}
}
\value{
(Invisibly) A \pkg{visNetwork} representation of the package network.
}
\description{
Plot interactive \pkg{visNetwork} visualisation of object-relationship
network of package.
}
\note{
Edge thicknesses are scaled to centrality within the package function
call network. Node sizes are scaled to numbers of times each function is
called from all other functions within a package.
}
\examples{
\dontrun{
tarball <- "magrittr_2.0.1.tar.gz"
u <- paste0 (
    "https://cran.r-project.org/src/contrib/",
    tarball
)
f <- file.path (tempdir (), tarball)
download.file (u, f)
p <- pkgstats (f)
plot_network (p)
}
}
\concept{output}
