/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Direction;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Paragraph;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.ParameterToken;
import com.dickimawbooks.texparserlib.PercentUnit;
import com.dickimawbooks.texparserlib.SbChar;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.SpChar;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.Spacer;
import com.dickimawbooks.texparserlib.SpecialListener;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserActionObject;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.Accent;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.BinarySymbol;
import com.dickimawbooks.texparserlib.generic.DelimiterSymbol;
import com.dickimawbooks.texparserlib.generic.DoubleLetterAccent;
import com.dickimawbooks.texparserlib.generic.EncodingSymbol;
import com.dickimawbooks.texparserlib.generic.GreekSymbol;
import com.dickimawbooks.texparserlib.generic.LoopCs;
import com.dickimawbooks.texparserlib.generic.MathAccent;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.Nbsp;
import com.dickimawbooks.texparserlib.generic.NewCount;
import com.dickimawbooks.texparserlib.generic.NewDimen;
import com.dickimawbooks.texparserlib.generic.NewToks;
import com.dickimawbooks.texparserlib.generic.ParAlign;
import com.dickimawbooks.texparserlib.generic.ParCs;
import com.dickimawbooks.texparserlib.generic.SpaceCs;
import com.dickimawbooks.texparserlib.generic.Symbol;
import com.dickimawbooks.texparserlib.generic.TeXParserSetUndefAction;
import com.dickimawbooks.texparserlib.generic.UndefinedActiveChar;
import com.dickimawbooks.texparserlib.primitives.Above;
import com.dickimawbooks.texparserlib.primitives.AboveWithDelims;
import com.dickimawbooks.texparserlib.primitives.Active;
import com.dickimawbooks.texparserlib.primitives.Advance;
import com.dickimawbooks.texparserlib.primitives.AfterGroup;
import com.dickimawbooks.texparserlib.primitives.BeginGroup;
import com.dickimawbooks.texparserlib.primitives.CatCodeCs;
import com.dickimawbooks.texparserlib.primitives.CharCs;
import com.dickimawbooks.texparserlib.primitives.ControlSpace;
import com.dickimawbooks.texparserlib.primitives.Csname;
import com.dickimawbooks.texparserlib.primitives.Def;
import com.dickimawbooks.texparserlib.primitives.Detokenize;
import com.dickimawbooks.texparserlib.primitives.DirectLua;
import com.dickimawbooks.texparserlib.primitives.DiscretionaryHyphen;
import com.dickimawbooks.texparserlib.primitives.DisplayStyle;
import com.dickimawbooks.texparserlib.primitives.Divide;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.EndCsname;
import com.dickimawbooks.texparserlib.primitives.EndGraf;
import com.dickimawbooks.texparserlib.primitives.EndGroup;
import com.dickimawbooks.texparserlib.primitives.EndInput;
import com.dickimawbooks.texparserlib.primitives.ExpandAfter;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.Global;
import com.dickimawbooks.texparserlib.primitives.HangIndent;
import com.dickimawbooks.texparserlib.primitives.If;
import com.dickimawbooks.texparserlib.primitives.IfCase;
import com.dickimawbooks.texparserlib.primitives.IfDim;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfNum;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.Ifx;
import com.dickimawbooks.texparserlib.primitives.IgnoreSpaces;
import com.dickimawbooks.texparserlib.primitives.ItalicCorrection;
import com.dickimawbooks.texparserlib.primitives.Jobname;
import com.dickimawbooks.texparserlib.primitives.Let;
import com.dickimawbooks.texparserlib.primitives.LongCs;
import com.dickimawbooks.texparserlib.primitives.Lowercase;
import com.dickimawbooks.texparserlib.primitives.Multiply;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import com.dickimawbooks.texparserlib.primitives.NoExpand;
import com.dickimawbooks.texparserlib.primitives.NumberCs;
import com.dickimawbooks.texparserlib.primitives.Or;
import com.dickimawbooks.texparserlib.primitives.OverWithDelims;
import com.dickimawbooks.texparserlib.primitives.ParIndent;
import com.dickimawbooks.texparserlib.primitives.ParSkip;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import com.dickimawbooks.texparserlib.primitives.Show;
import com.dickimawbooks.texparserlib.primitives.Skip;
import com.dickimawbooks.texparserlib.primitives.Special;
import com.dickimawbooks.texparserlib.primitives.StringCs;
import com.dickimawbooks.texparserlib.primitives.TeXFontFamilyDeclaration;
import com.dickimawbooks.texparserlib.primitives.TeXFontShapeDeclaration;
import com.dickimawbooks.texparserlib.primitives.TeXFontWeightDeclaration;
import com.dickimawbooks.texparserlib.primitives.TextStyle;
import com.dickimawbooks.texparserlib.primitives.TheCs;
import com.dickimawbooks.texparserlib.primitives.UnSkip;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import com.dickimawbooks.texparserlib.primitives.Unexpanded;
import com.dickimawbooks.texparserlib.primitives.Uppercase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Vector;

public abstract class DefaultTeXParserListener
extends TeXParserListener {
    protected Writeable writeable;
    protected Vector<TeXPath> referencedFiles;
    protected Vector<SpecialListener> specialListeners;
    public static final IfTrue IFTRUE = new IfTrue();
    public static final IfFalse IFFALSE = new IfFalse();
    protected UndefAction undefAction = UndefAction.ERROR;
    protected HashMap<Integer, Float> pageDimensions;

    public DefaultTeXParserListener(Writeable writeable) {
        this.writeable = writeable;
        this.init();
    }

    private void init() {
        this.referencedFiles = new Vector();
        this.specialListeners = new Vector();
        this.pageDimensions = new HashMap();
        this.pageDimensions.put(5, Float.valueOf(468.0f));
        this.pageDimensions.put(6, Float.valueOf(640.8f));
        this.pageDimensions.put(2, Float.valueOf(468.0f));
        this.pageDimensions.put(4, Float.valueOf(640.8f));
        this.pageDimensions.put(0, Float.valueOf(468.0f));
        this.pageDimensions.put(1, Float.valueOf(468.0f));
        this.pageDimensions.put(3, Float.valueOf(640.8f));
        this.pageDimensions.put(7, Float.valueOf(612.0f));
        this.pageDimensions.put(8, Float.valueOf(1008.0f));
        this.pageDimensions.put(9, Float.valueOf(64.8f));
    }

    @Override
    protected void addPredefined() {
        this.parser.putActiveChar(new Nbsp());
        Accent.addCommands(this.parser);
        Symbol.addCommands(this.parser, this);
        ParAlign.addCommands(this.parser);
        this.parser.putControlSequence(new Above());
        this.parser.putControlSequence(new AboveWithDelims());
        this.parser.putControlSequence(new ControlSpace());
        this.parser.putControlSequence(new SpaceCs());
        this.parser.putControlSequence(new SpaceCs("\n"));
        this.parser.putControlSequence(new SpaceCs("\t"));
        this.parser.putControlSequence(new DiscretionaryHyphen());
        this.parser.putControlSequence(new ItalicCorrection());
        this.parser.putControlSequence(new OverWithDelims());
        this.parser.putControlSequence(new Accent("a"));
        this.parser.putControlSequence(new Relax());
        this.parser.putControlSequence(new UnSkip());
        this.parser.putControlSequence(new Unexpanded());
        this.parser.putControlSequence(new DisplayStyle());
        this.parser.putControlSequence(new TextStyle());
        this.parser.putControlSequence(new StringCs());
        this.parser.putControlSequence(new Detokenize());
        this.parser.putControlSequence(new EndInput());
        this.parser.putControlSequence(new ParCs());
        this.parser.putControlSequence(new EndGraf());
        this.parser.putControlSequence(new Special());
        this.parser.putControlSequence(new GenericCommand("empty"));
        this.parser.putControlSequence(new Def());
        this.parser.putControlSequence(new Def("gdef", true, false));
        this.parser.putControlSequence(new Let());
        this.parser.putControlSequence(new Special());
        this.parser.putControlSequence(new Jobname());
        this.parser.putControlSequence(new NumberCs());
        this.parser.putControlSequence(new RomanNumeral());
        this.parser.putControlSequence(new TheCs());
        this.parser.putControlSequence(new CharCs());
        this.parser.putControlSequence(new CatCodeCs());
        this.parser.putControlSequence(new ExpandAfter());
        this.parser.putControlSequence(new AfterGroup());
        this.parser.putControlSequence(new Csname());
        this.parser.putControlSequence(new EndCsname());
        this.parser.putControlSequence(new IgnoreSpaces());
        this.parser.putControlSequence(new If());
        this.parser.putControlSequence(new Ifx());
        this.parser.putControlSequence(IFTRUE);
        this.parser.putControlSequence(IFFALSE);
        this.parser.putControlSequence(new Else());
        this.parser.putControlSequence(new Or());
        this.parser.putControlSequence(new Fi());
        this.parser.putControlSequence(new IfCase());
        this.parser.putControlSequence(new NewIf());
        this.parser.putControlSequence(new NewCount());
        this.parser.putControlSequence(new NewDimen());
        this.parser.putControlSequence(new NewToks());
        this.parser.putControlSequence(new Global());
        this.parser.putControlSequence(new LongCs());
        this.parser.putControlSequence(new BeginGroup());
        this.parser.putControlSequence(new EndGroup());
        this.parser.putControlSequence(new AssignedControlSequence("bgroup", this.getBgChar(this.parser.getBgChar())));
        this.parser.putControlSequence(new AssignedControlSequence("egroup", this.getEgChar(this.parser.getEgChar())));
        this.parser.putControlSequence(new LoopCs());
        this.parser.putControlSequence(new Advance());
        this.parser.putControlSequence(new Multiply());
        this.parser.putControlSequence(new Divide());
        this.parser.putControlSequence(new IfNum());
        this.parser.putControlSequence(new IfDim());
        this.parser.putControlSequence(new TeXParserSetUndefAction());
        this.parser.putControlSequence(new HangIndent());
        this.parser.putControlSequence(new ParIndent());
        this.parser.putControlSequence(new ParSkip());
        this.parser.putControlSequence(new Skip("hskip", Direction.HORIZONTAL));
        this.parser.putControlSequence(new Skip("vskip", Direction.VERTICAL));
        this.parser.putControlSequence(new Active());
        this.parser.putControlSequence(new NoExpand());
        this.parser.putControlSequence(new DirectLua());
        this.parser.putControlSequence(new MathAccent("vec", 8407));
        this.parser.putControlSequence(new MathAccent("hat", 770, 710));
        this.parser.putControlSequence(new MathAccent("check", 780, 711));
        this.parser.putControlSequence(new MathAccent("breve", 774, 728));
        this.parser.putControlSequence(new MathAccent("acute", 769, 180));
        this.parser.putControlSequence(new MathAccent("grave", 768, 96));
        this.parser.putControlSequence(new MathAccent("tilde", 771, 732));
        this.parser.putControlSequence(new MathAccent("bar", 772, 175));
        this.parser.putControlSequence(new MathAccent("dot", 775, 729));
        this.parser.putControlSequence(new MathAccent("ddot", 776, 168));
        this.parser.putControlSequence(new DoubleLetterAccent("t", 860, 8255));
        this.parser.putControlSequence(new Uppercase());
        this.parser.putControlSequence(new Lowercase());
        this.parser.putControlSequence(new Show());
        this.parser.putControlSequence(new GenericCommand(true, "lq", null, new TeXObject[]{this.getOther(96)}));
        this.parser.putControlSequence(new GenericCommand(true, "rq", null, new TeXObject[]{this.getOther(39)}));
        this.parser.putControlSequence(new GenericCommand(true, ",", null, new TeXObject[]{this.getOther(8198)}));
        this.parser.putControlSequence(new GenericCommand(true, "@"));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("rm", TeXFontFamily.RM));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("sf", TeXFontFamily.SF));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("tt", TeXFontFamily.TT));
        this.parser.putControlSequence(this.getTeXFontFamilyDeclaration("cal", TeXFontFamily.CAL));
        this.parser.putControlSequence(this.getTeXFontWeightDeclaration("bf", TeXFontWeight.BF));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("it", TeXFontShape.IT));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("sl", TeXFontShape.SL));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("em", TeXFontShape.EM));
        this.parser.putControlSequence(this.getTeXFontShapeDeclaration("sc", TeXFontShape.SC));
        this.newlength("hsize", 1.0f, new PercentUnit(5));
        this.newlength("vsize", 1.0f, new PercentUnit(6));
    }

    public ControlSequence getTeXFontFamilyDeclaration(String string, TeXFontFamily teXFontFamily) {
        return new TeXFontFamilyDeclaration(string, teXFontFamily);
    }

    public ControlSequence getTeXFontShapeDeclaration(String string, TeXFontShape teXFontShape) {
        return new TeXFontShapeDeclaration(string, teXFontShape);
    }

    public ControlSequence getTeXFontWeightDeclaration(String string, TeXFontWeight teXFontWeight) {
        return new TeXFontWeightDeclaration(string, teXFontWeight);
    }

    public void putControlSequence(ControlSequence controlSequence) {
        this.getParser().putControlSequence(controlSequence);
    }

    public void putControlSequence(boolean bl, ControlSequence controlSequence) {
        this.getParser().putControlSequence(bl, controlSequence);
    }

    public UndefAction getUndefinedAction() {
        return this.undefAction;
    }

    public void setUndefinedAction(UndefAction undefAction) {
        this.undefAction = undefAction;
    }

    @Deprecated
    public void setUndefinedAction(byte by) {
        switch (by) {
            case 0: {
                this.undefAction = UndefAction.ERROR;
                break;
            }
            case 1: {
                this.undefAction = UndefAction.WARN;
                break;
            }
            case 2: {
                this.undefAction = UndefAction.MESSAGE;
                break;
            }
            case 3: {
                this.undefAction = UndefAction.IGNORE;
            }
        }
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new Undefined(string, this.undefAction);
    }

    public DimenRegister newlength(boolean bl, String string) {
        return this.parser.getSettings().newdimen(bl, string);
    }

    public DimenRegister newlength(String string, TeXDimension teXDimension) throws TeXSyntaxException {
        DimenRegister dimenRegister = this.parser.getSettings().newdimen(string);
        dimenRegister.setDimension(this.getParser(), teXDimension);
        return dimenRegister;
    }

    public DimenRegister newlength(String string, float f, TeXUnit teXUnit) {
        DimenRegister dimenRegister = this.parser.getSettings().newdimen(string);
        try {
            dimenRegister.setDimension(this.getParser(), new UserDimension(f, teXUnit));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
        return dimenRegister;
    }

    public CountRegister newcount(boolean bl, String string) {
        return this.parser.getSettings().newcount(bl, string);
    }

    public CountRegister newcount(String string, TeXNumber teXNumber) throws TeXSyntaxException {
        CountRegister countRegister = this.parser.getSettings().newcount(string);
        countRegister.setValue(this.getParser(), teXNumber);
        return countRegister;
    }

    public CountRegister newcount(String string, int n) {
        CountRegister countRegister = this.parser.getSettings().newcount(string);
        try {
            countRegister.setValue(this.getParser(), new UserNumber(n));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
        return countRegister;
    }

    public TokenRegister newtoks(boolean bl, String string) {
        return this.parser.getSettings().newtoks(bl, string);
    }

    @Override
    public ActiveChar getActiveChar(int n) {
        ActiveChar activeChar = this.getParser().getActiveChar(n);
        if (activeChar == null) {
            activeChar = this.getUndefinedActiveChar(n);
        }
        return activeChar;
    }

    public ActiveChar getUndefinedActiveChar(int n) {
        return new UndefinedActiveChar(n);
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.getParser().putActiveChar(activeChar);
    }

    @Override
    public BgChar getBgChar(int n) {
        return new BgChar(n);
    }

    @Override
    public EgChar getEgChar(int n) {
        return new EgChar(n);
    }

    @Override
    public Eol getEol() {
        return new Eol();
    }

    @Override
    public Par getPar() {
        return new Par();
    }

    @Override
    public Paragraph createParagraph() {
        return new Paragraph();
    }

    @Override
    public Space getSpace() {
        return new Space();
    }

    @Override
    public Spacer getSpacer(Direction direction, TeXDimension teXDimension, boolean bl) {
        return new Spacer(direction, teXDimension, bl);
    }

    @Override
    public Param getParam(int n) {
        return new Param(n);
    }

    @Override
    public DoubleParam getDoubleParam(ParameterToken parameterToken) {
        return new DoubleParam(parameterToken);
    }

    @Override
    public Tab getTab(int n) {
        return new Tab(n);
    }

    @Override
    public Letter getLetter(int n) {
        return new Letter(n);
    }

    @Override
    public Other getOther(int n) {
        return new Other(n);
    }

    @Override
    public TeXObjectList createString(String string) {
        return new TeXObjectList(this, string);
    }

    @Override
    public TeXObjectList createStack() {
        TeXObjectList teXObjectList = new TeXObjectList();
        if (this.getParser().isDebugMode(128)) {
            this.getParser().logMessage("CREATED STACK " + teXObjectList);
        }
        return teXObjectList;
    }

    @Override
    public DataObjectList createDataList() {
        return new DataObjectList();
    }

    @Override
    public DataObjectList createDataList(boolean bl) {
        return new DataObjectList(bl);
    }

    @Override
    public DataObjectList createDataList(String string) {
        return new DataObjectList(this, string);
    }

    @Override
    public DataObjectList createDataList(String string, boolean bl) {
        return new DataObjectList(this, string, bl);
    }

    @Override
    public SkippedSpaces createSkippedSpaces() {
        return new SkippedSpaces();
    }

    @Override
    public SkippedEols createSkippedEols() {
        return new SkippedEols();
    }

    @Override
    public BinarySymbol createBinarySymbol(String string, int n) {
        return new BinarySymbol(string, n);
    }

    @Override
    public Symbol createSymbol(String string, int n) {
        return new Symbol(string, n);
    }

    @Override
    public ControlSequence createSymbol(String string, int n, FontEncoding fontEncoding) {
        return new EncodingSymbol(string, n, fontEncoding);
    }

    @Override
    public GreekSymbol createGreekSymbol(String string, int n) {
        return new GreekSymbol(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new MathSymbol(string, n);
    }

    @Override
    public DelimiterSymbol createDelimiterSymbol(String string, int n) {
        return new DelimiterSymbol(string, n);
    }

    public BigOperator createBigOperator(String string, int n) {
        return new BigOperator(string, n);
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new BigOperator(string, n, n2);
    }

    @Override
    public Group createGroup() {
        return new Group();
    }

    @Override
    public Group createGroup(String string) {
        return new Group(this, string);
    }

    @Override
    public MathGroup createMathGroup() {
        return new MathGroup();
    }

    @Override
    public SpChar createSpChar(int n) {
        return new SpChar(n);
    }

    @Override
    public SbChar createSbChar(int n) {
        return new SbChar(n);
    }

    @Override
    public Comment createComment() {
        return new Comment();
    }

    @Override
    public boolean input(TeXPath teXPath, TeXObjectList teXObjectList) throws IOException {
        if (teXPath != null && Files.exists(teXPath.getPath(), new LinkOption[0])) {
            if (teXObjectList == null || teXObjectList == this.getParser()) {
                this.parser.push(TeXParserActionObject.createInputAction(teXPath, null));
            } else {
                this.parser.push(TeXParserActionObject.createInputAction(teXPath, teXObjectList));
            }
            return true;
        }
        return false;
    }

    @Override
    public TeXObject createAnchor(String string, TeXObject teXObject) throws IOException {
        this.getParser().debugMessage(64, "No hyperlink anchor supported. Anchor: " + string);
        return teXObject;
    }

    @Override
    public TeXObject createLink(String string, TeXObject teXObject) throws IOException {
        this.getParser().debugMessage(64, "No hyperlink supported. Anchor: " + string);
        return teXObject;
    }

    @Override
    public File getOutputDir() {
        return this.getParser().getBaseDir();
    }

    @Override
    public Writeable getWriteable() {
        return this.writeable;
    }

    public void setWriteable(Writeable writeable) {
        this.writeable = writeable;
    }

    public boolean isFileLoaded(String string, String string2) {
        return this.isFileLoaded(String.format("%s.%s", string, string2));
    }

    public boolean isFileLoaded(String string) {
        for (TeXPath teXPath : this.referencedFiles) {
            if (!teXPath.getLeaf().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFileReference(TeXPath teXPath) {
        if (!this.referencedFiles.contains(teXPath)) {
            this.referencedFiles.add(teXPath);
        }
    }

    public boolean removeFileReference(TeXPath teXPath) {
        return this.referencedFiles.remove(teXPath);
    }

    public TeXPath getLastFileReference() {
        int n = this.referencedFiles.size();
        return n == 0 ? null : this.referencedFiles.get(n - 1);
    }

    public void addSpecialListener(SpecialListener specialListener) {
        this.specialListeners.add(specialListener);
    }

    public void removeSpecialListener(SpecialListener specialListener) {
        this.specialListeners.remove(specialListener);
    }

    @Override
    public TeXObjectList special(String string) throws IOException {
        for (SpecialListener specialListener : this.specialListeners) {
            TeXObjectList teXObjectList = specialListener.process(this.parser, string);
            if (teXObjectList == null) continue;
            return teXObjectList;
        }
        return null;
    }

    @Override
    public TeXObjectList directlua(String string) throws IOException {
        this.getParser().warningMessage("warning.unsupported.generic", "\\directlua");
        return null;
    }

    @Override
    public void verb(String string, boolean bl, int n, String string2) throws IOException {
        if (bl) {
            int n2;
            for (int i = 0; i < string2.length(); i += Character.charCount(n2)) {
                n2 = string2.codePointAt(i);
                if (n2 == 32) {
                    this.writeable.writeCodePoint(9251);
                    continue;
                }
                this.writeable.writeCodePoint(n2);
            }
        } else {
            this.writeable.write(string2);
        }
    }

    public void rotate(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void rotate(double d, double d2, double d3, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.rotate(d, teXParser, teXObjectList, teXObject);
    }

    public void rotate(double d, TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.rotate(d, teXParser, teXObjectList, teXObject);
    }

    public void scale(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.scale(d, d, teXParser, teXObjectList, teXObject);
    }

    public void scale(double d, double d2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void scaleX(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void scaleY(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void resize(TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void resizeX(TeXDimension teXDimension, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void resizeY(TeXDimension teXDimension, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public void translate(TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }

    public Vector<TeXPath> getFileList() {
        return this.referencedFiles;
    }

    public TeXObjectList requestUserInputAsList(String string) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        this.requestUserInput(string, teXObjectList);
        return teXObjectList;
    }

    public void requestUserInput(String string, TeXObjectList teXObjectList) throws IOException {
        String string2 = this.getTeXApp().requestUserInput(string);
        if (string2 != null && !string2.isEmpty()) {
            this.getParser().scan(string2, teXObjectList);
        }
    }

    public boolean isIfTrue(ControlSequence controlSequence) {
        return IFTRUE.equals(controlSequence);
    }

    public boolean isIfFalse(ControlSequence controlSequence) {
        return IFFALSE.equals(controlSequence);
    }

    @Override
    public float getPageDimension(int n) {
        Float f = this.pageDimensions.get(n);
        return f == null ? 0.0f : f.floatValue();
    }

    public void setPageDimension(int n, float f) {
        this.pageDimensions.put(n, Float.valueOf(f));
    }
}

