/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import tools.jackson.core.util.JacksonFeature;

public enum StreamWriteFeature implements JacksonFeature
{
    AUTO_CLOSE_CONTENT(true),
    AUTO_CLOSE_TARGET(true),
    FLUSH_PASSED_TO_STREAM(true),
    WRITE_BIGDECIMAL_AS_PLAIN(false),
    IGNORE_UNKNOWN(false),
    STRICT_DUPLICATE_DETECTION(false),
    USE_FAST_DOUBLE_WRITER(false);

    private final boolean _defaultState;
    private final int _mask = 1 << this.ordinal();

    private StreamWriteFeature(boolean defaultState) {
        this._defaultState = defaultState;
    }

    public static int collectDefaults() {
        int flags = 0;
        for (StreamWriteFeature f : StreamWriteFeature.values()) {
            if (!f.enabledByDefault()) continue;
            flags |= f.getMask();
        }
        return flags;
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public boolean enabledIn(int flags) {
        return (flags & this._mask) != 0;
    }

    @Override
    public int getMask() {
        return this._mask;
    }
}

