/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.IDocTypeHandler;
import org.attoparser.ParseException;
import org.attoparser.ParsingLocatorUtil;
import org.attoparser.ParsingMarkupUtil;

public final class ParsingDocTypeMarkupUtil {
    private static final char[] DOCTYPE_TYPE_PUBLIC_UPPER = "PUBLIC".toCharArray();
    private static final char[] DOCTYPE_TYPE_PUBLIC_LOWER = "public".toCharArray();
    private static final char[] DOCTYPE_TYPE_SYSTEM_UPPER = "SYSTEM".toCharArray();
    private static final char[] DOCTYPE_TYPE_SYSTEM_LOWER = "system".toCharArray();

    private ParsingDocTypeMarkupUtil() {
    }

    public static void parseDocType(char[] buffer, int offset, int len, int line, int col, IDocTypeHandler handler) throws ParseException {
        if (len < 10 || !ParsingDocTypeMarkupUtil.isDocTypeStart(buffer, offset, offset + len) || !ParsingDocTypeMarkupUtil.isDocTypeEnd(buffer, offset + len - 1, offset + len)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 3;
        int internalSubsetLastChar = ParsingDocTypeMarkupUtil.findInternalSubsetEndChar(buffer, contentOffset, contentLen);
        if (internalSubsetLastChar == -1) {
            ParsingDocTypeMarkupUtil.doParseDetailedDocTypeWithInternalSubset(buffer, contentOffset, contentLen, offset, len, line, col, 0, 0, 0, 0, handler);
            return;
        }
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int internalSubsetStart = ParsingDocTypeMarkupUtil.findInternalSubsetStartCharWildcard(buffer, contentOffset, maxi, locator);
        if (internalSubsetStart == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        ParsingDocTypeMarkupUtil.doParseDetailedDocTypeWithInternalSubset(buffer, contentOffset, internalSubsetStart - contentOffset, offset, len, line, col, internalSubsetStart + 1, internalSubsetLastChar - internalSubsetStart - 1, locator[0], locator[1], handler);
    }

    private static void doParseDetailedDocTypeWithInternalSubset(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, IDocTypeHandler handler) throws ParseException {
        int i = contentOffset;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int keywordEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, false, locator);
        if (keywordEnd == -1) {
            handler.handleDocType(buffer, i, maxi - i, line, col + 2, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int keywordOffset = i;
        int keywordLen = keywordEnd - keywordOffset;
        int keywordLine = line;
        int keywordCol = col + 2;
        i = keywordEnd;
        int currentDocTypeLine = locator[0];
        int currentDocTypeCol = locator[1];
        int elementNameStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (elementNameStart == -1) {
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(currentDocTypeLine, internalSubsetLine), Math.max(currentDocTypeCol, internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i = elementNameStart;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int elementNameEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, false, locator);
        if (elementNameEnd == -1) {
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, i, maxi - i, currentDocTypeLine, currentDocTypeCol, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int elementNameOffset = elementNameStart;
        int elementNameLen = elementNameEnd - elementNameOffset;
        int elementNameLine = currentDocTypeLine;
        int elementNameCol = currentDocTypeCol;
        i = elementNameEnd;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int typeStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (typeStart == -1) {
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i = typeStart;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int typeEnd = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, true, locator);
        if (typeEnd == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": If a type is specified (PUBLIC or SYSTEM), at least a public or a system ID has to be specified", line, col);
        }
        int typeOffset = typeStart;
        int typeLen = typeEnd - typeOffset;
        int typeLine = currentDocTypeLine;
        int typeCol = currentDocTypeCol;
        i = typeEnd;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeType(buffer, typeOffset, typeLen)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": DOCTYPE type must be either \"PUBLIC\" or \"SYSTEM\"", line, col);
        }
        boolean isTypePublic = buffer[typeOffset] == DOCTYPE_TYPE_PUBLIC_UPPER[0] || buffer[typeOffset] == DOCTYPE_TYPE_PUBLIC_LOWER[0];
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec1Start = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (spec1Start == -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": If a type is specified (PUBLIC or SYSTEM), at least a public or a system ID has to be specified", line, col);
        }
        i = spec1Start;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec1End = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, true, locator);
        if (spec1End == -1) {
            if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, i, maxi - i)) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
            }
            if (isTypePublic) {
                handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, i + 1, maxi - (i + 2), currentDocTypeLine, currentDocTypeCol, 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
                return;
            }
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, 0, 0, currentDocTypeLine, currentDocTypeCol, i + 1, maxi - (i + 2), currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int spec1Offset = spec1Start;
        int spec1Len = spec1End - spec1Offset;
        int spec1Line = currentDocTypeLine;
        int spec1Col = currentDocTypeCol;
        i = spec1End;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, spec1Offset, spec1Len)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
        }
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec2Start = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (spec2Start == -1) {
            if (isTypePublic) {
                handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, 0, 0, locator[0], locator[1], internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
                return;
            }
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, 0, 0, spec1Line, spec1Col, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        i = spec2Start;
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int spec2End = ParsingMarkupUtil.findNextWhitespaceCharWildcard(buffer, i, maxi, true, locator);
        if (spec2End == -1) {
            if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, i, maxi - i)) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
            }
            if (!isTypePublic) {
                throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": type SYSTEM only allows specifying one element (a system ID)", line, col);
            }
            handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, i + 1, maxi - (i + 2), currentDocTypeLine, currentDocTypeCol, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
            return;
        }
        int spec2Offset = spec2Start;
        int spec2Len = spec2End - spec2Offset;
        int spec2Line = currentDocTypeLine;
        int spec2Col = currentDocTypeCol;
        i = spec2End;
        if (!ParsingDocTypeMarkupUtil.isValidDocTypeSpec(buffer, spec2Start, spec2Len)) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": Public and Systen IDs must be surrounded by quotes (\")", line, col);
        }
        if (!isTypePublic) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": type SYSTEM only allows specifying one element (a system ID)", line, col);
        }
        currentDocTypeLine = locator[0];
        currentDocTypeCol = locator[1];
        int clauseEndStart = ParsingMarkupUtil.findNextNonWhitespaceCharWildcard(buffer, i, maxi, locator);
        if (clauseEndStart != -1) {
            throw new ParseException("Could not parse as a well-formed DOCTYPE clause \"" + new String(buffer, outerOffset, outerLen) + "\": More elements found than allowed", line, col);
        }
        handler.handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, spec1Offset + 1, spec1Len - 2, spec1Line, spec1Col, spec2Offset + 1, spec2Len - 2, spec2Line, spec2Col, internalSubsetOffset, internalSubsetLen, Math.max(locator[0], internalSubsetLine), Math.max(locator[1], internalSubsetCol), outerOffset, outerLen, line, col);
    }

    static boolean isDocTypeStart(char[] buffer, int offset, int maxi) {
        return !(maxi - offset <= 9 || buffer[offset] != '<' || buffer[offset + 1] != '!' || buffer[offset + 2] != 'D' && buffer[offset + 2] != 'd' || buffer[offset + 3] != 'O' && buffer[offset + 3] != 'o' || buffer[offset + 4] != 'C' && buffer[offset + 4] != 'c' || buffer[offset + 5] != 'T' && buffer[offset + 5] != 't' || buffer[offset + 6] != 'Y' && buffer[offset + 6] != 'y' || buffer[offset + 7] != 'P' && buffer[offset + 7] != 'p' || buffer[offset + 8] != 'E' && buffer[offset + 8] != 'e' || !Character.isWhitespace(buffer[offset + 9]) && buffer[offset + 9] != '>');
    }

    static boolean isDocTypeEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 0 && buffer[offset] == '>';
    }

    private static boolean isValidDocTypeType(char[] buffer, int offset, int len) {
        if (len != 6) {
            return false;
        }
        if (buffer[offset] == DOCTYPE_TYPE_PUBLIC_UPPER[0] || buffer[offset] == DOCTYPE_TYPE_PUBLIC_LOWER[0]) {
            for (int i = 1; i < 6; ++i) {
                if (buffer[offset + i] == DOCTYPE_TYPE_PUBLIC_UPPER[i] || buffer[offset + i] == DOCTYPE_TYPE_PUBLIC_LOWER[i]) continue;
                return false;
            }
            return true;
        }
        if (buffer[offset] == DOCTYPE_TYPE_SYSTEM_UPPER[0] || buffer[offset] == DOCTYPE_TYPE_SYSTEM_LOWER[0]) {
            for (int i = 1; i < 6; ++i) {
                if (buffer[offset + i] == DOCTYPE_TYPE_SYSTEM_UPPER[i] || buffer[offset + i] == DOCTYPE_TYPE_SYSTEM_LOWER[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValidDocTypeSpec(char[] buffer, int offset, int len) {
        return len >= 2 && (buffer[offset] == '\"' && buffer[offset + len - 1] == '\"' || buffer[offset] == '\'' && buffer[offset + len - 1] == '\'');
    }

    private static int findInternalSubsetEndChar(char[] buffer, int offset, int len) {
        int maxi = offset + len;
        for (int i = maxi - 1; i > offset; --i) {
            char c = buffer[i];
            if (Character.isWhitespace(c)) continue;
            if (c == ']') {
                return i;
            }
            return -1;
        }
        return -1;
    }

    private static int findInternalSubsetStartCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        for (int i = offset; i < maxi; ++i) {
            char c = text[i];
            if (!inApos && c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes && c == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && c == '[') {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
        }
        return -1;
    }

    static int findNextDocTypeStructureEnd(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int bracketLevel = 0;
        for (int i = offset; i < maxi; ++i) {
            char c = text[i];
            if (!inApos && c == '\"') {
                inQuotes = !inQuotes;
            } else if (!inQuotes && c == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && c == '[') {
                ++bracketLevel;
            } else if (!inQuotes && !inApos && c == ']') {
                --bracketLevel;
            } else if (!inQuotes && !inApos && bracketLevel == 0 && c == '>') {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
        }
        if (bracketLevel != 0) {
            return -2;
        }
        return -1;
    }
}

