/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.annotation.Select;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.jdt.NodeProcessor;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.TypeInfo;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;

public class MethodVisitor
extends ASTVisitor {
    private ClassInfo classInfo_;
    private NodeProcessor nodeProcessor_;

    public MethodVisitor(ClassInfo classInfo, Map<String, IBinding> map, NodeProcessor nodeProcessor) {
        this.classInfo_ = classInfo;
        this.nodeProcessor_ = nodeProcessor;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        ToolsLogger.getLogger().log(Level.FINEST, "gathering info for method: " + methodDeclaration.toString());
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setMethodName(methodDeclaration.getName().getFullyQualifiedName());
        methodInfo.setConstructor(methodDeclaration.isConstructor());
        this.setDocumentProperties(methodInfo, methodDeclaration);
        this.nodeProcessor_.processModifierAndAnnotations(methodDeclaration.modifiers(), methodInfo);
        IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
        if (iMethodBinding == null) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_RESOLVE_MET", methodDeclaration.toString()), null, 10218, null, methodInfo);
        }
        if (methodInfo.getAnnotationType() == null) {
            ToolsLogger.getLogger().log(Level.FINEST, "Skipping method with no annotation: " + iMethodBinding.getKey());
            return true;
        }
        methodInfo.setJavaMethodSignature(iMethodBinding.getKey());
        this.processParameters(methodDeclaration, methodInfo);
        this.processReturnType(methodDeclaration, methodInfo);
        this.processTypeParameters(methodDeclaration, methodInfo);
        this.nodeProcessor_.processNestedBeanForJoinPointInfo(methodInfo);
        if (methodInfo.getAnnotationType() != null) {
            this.classInfo_.addMethodInfoToList(methodInfo);
        }
        return true;
    }

    private void setDocumentProperties(MethodInfo methodInfo, MethodDeclaration methodDeclaration) {
        int n2 = methodDeclaration.getStartPosition();
        methodInfo.setStartPosition(n2);
        methodInfo.setLength(methodDeclaration.getLength());
        ASTNode aSTNode = methodDeclaration.getRoot();
        if (aSTNode != null && aSTNode.getNodeType() == 15) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode;
            methodInfo.setLineNumber(compilationUnit.getLineNumber(n2));
            methodInfo.setColumnNumber(compilationUnit.getColumnNumber(n2));
        }
    }

    private void processParameters(MethodDeclaration methodDeclaration, MethodInfo methodInfo) {
        List list = methodDeclaration.parameters();
        int n2 = 0;
        if (list != null) {
            Object object2;
            for (Object object2 : list) {
                ToolsLogger.getLogger().log(Level.FINEST, "gathering info for parameter: " + object2.toString());
                TypeInfo typeInfo = new TypeInfo();
                this.nodeProcessor_.processParameter((SingleVariableDeclaration)object2, typeInfo, methodInfo, n2);
                typeInfo.setTypeString(object2.toString());
                methodInfo.addParameterToList(typeInfo);
                ++n2;
            }
            List<TypeInfo> list2 = methodInfo.getParameterListWithoutHandlers();
            if (list2 != null && list2.size() == 1 && ((TypeInfo)list2.get(0)).isBeanType() && (object2 = methodInfo.getInputBeanInfo().get(0).getAutoGeneratedKeys()) != null) {
                methodInfo.setHasAutoGeneratedKeys(true);
            }
            object2 = null;
            object2 = methodInfo.getAnnotationType();
            if (object2 != null && Select.class != object2) {
                this.checkAndSetInfoForQOC(false, methodInfo);
            } else if (list2 != null && list2.size() > 0) {
                for (TypeInfo typeInfo : list2) {
                    JavaType javaType;
                    if (typeInfo.isArrayType() && typeInfo.getBaseType().getJavaType() != JavaType.OBJECT && typeInfo.getBaseType().getJavaType() != JavaType.SIMPLE_BYTE) {
                        this.checkAndSetInfoForQOC(true, methodInfo);
                        continue;
                    }
                    if (!typeInfo.isParameterizedType() || (javaType = typeInfo.getJavaType()) != JavaType.ITERABLE && javaType != JavaType.ITERATOR && javaType != JavaType.LIST && javaType != JavaType.DERIVEDLIST && javaType != JavaType.COLLECTION) continue;
                    this.checkAndSetInfoForQOC(true, methodInfo);
                }
            }
        }
    }

    private void checkAndSetInfoForQOC(boolean bl2, MethodInfo methodInfo) {
        if (this.classInfo_.isGenerateForQOC() && !bl2) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_MIX_QOC", new Object[0]), null, 10219, null, methodInfo);
        }
        this.classInfo_.setGenerateForQOC(bl2);
    }

    private void processReturnType(MethodDeclaration methodDeclaration, MethodInfo methodInfo) {
        Type type = methodDeclaration.getReturnType2();
        ToolsLogger.getLogger().log(Level.FINEST, "gathering info for return type: " + type.toString());
        TypeInfo typeInfo = new TypeInfo();
        this.nodeProcessor_.processReturnType(type, typeInfo, methodInfo, 1);
    }

    private void processTypeParameters(MethodDeclaration methodDeclaration, MethodInfo methodInfo) {
        List list = methodDeclaration.typeParameters();
        ToolsLogger.getLogger().log(Level.FINEST, "gathering info for method type parameters: " + list.toString());
        for (TypeParameter typeParameter : list) {
            this.nodeProcessor_.processTypeParameter(typeParameter, methodInfo);
        }
    }
}

