/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class JSONHelper {
    private static CharsetDecoder decoder_ = Charset.forName("UTF-8").newDecoder();

    public static String serialize(JSONArray jSONArray) {
        try {
            return jSONArray.serialize();
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, iOException.getMessage(), null, 10624);
        }
    }

    public static byte[] serializeToBytes(JSONArray jSONArray) {
        try {
            return jSONArray.serialize().getBytes("UTF-8");
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, iOException.getMessage(), null, 10623);
        }
    }

    public static synchronized String decodeJSONMessage(Message message) {
        try {
            return decoder_.decode(message.getPayload().duplicate()).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, characterCodingException.getMessage(), null, 10622);
        }
    }

    public static synchronized CharBuffer decodeJSONMessage(ByteBuffer byteBuffer) {
        try {
            return decoder_.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, characterCodingException.getMessage(), null, 10621);
        }
    }

    public static JSONArray convertJSONByteBuffer(Message message) {
        String string = JSONHelper.decodeJSONMessage(message);
        try {
            return JSONArray.parse(string);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, iOException.getMessage(), null, 10620);
        }
    }

    public static Properties createPropertiesFromJSONArray(JSONArray jSONArray, int n2) {
        JSONObject jSONObject = (JSONObject)jSONArray.get(n2);
        Properties properties = new Properties();
        if (jSONObject != null) {
            for (String string : jSONObject.keySet()) {
                String string2 = jSONObject.get(string).toString();
                properties.put(string, string2);
            }
        }
        return properties;
    }

    public static HashMap<String, String> createStringHashMapFromJSONArray(JSONArray jSONArray, int n2) {
        JSONObject jSONObject = (JSONObject)jSONArray.get(n2);
        HashMap<String, String> hashMap = null;
        if (jSONObject != null) {
            hashMap = new HashMap<String, String>();
            for (String string : jSONObject.keySet()) {
                String string2 = jSONObject.get(string).toString();
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    public static HashMap<String, String> createStringHashMapFromJSONObject(JSONObject jSONObject) {
        HashMap<String, String> hashMap = null;
        if (jSONObject != null) {
            hashMap = new HashMap<String, String>();
            for (String string : jSONObject.keySet()) {
                String string2 = (String)jSONObject.get(string);
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    public static HashMap<String, Object> createObjectHashMapFromJSONObject(JSONObject jSONObject) {
        HashMap hashMap = null;
        if (jSONObject != null) {
            hashMap = new HashMap();
            for (String string : jSONObject.keySet()) {
                Object v2 = jSONObject.get(string);
                hashMap.put(string, v2);
            }
        }
        return hashMap;
    }

    public static String[] createStringArrayFromJSONArray(JSONArray jSONArray) {
        String[] stringArray = null;
        if (jSONArray != null) {
            stringArray = jSONArray.toArray(new String[jSONArray.size()]);
        }
        return stringArray;
    }

    public static String[][] createArrayOfArraysOfClientInfo(JSONArray jSONArray) {
        String[][] stringArrayArray = null;
        JSONArray[] jSONArrayArray = null;
        if (jSONArray != null) {
            jSONArrayArray = jSONArray.toArray(new JSONArray[jSONArray.size()]);
            stringArrayArray = new String[jSONArrayArray.length][];
            for (int i10 = 0; i10 < jSONArrayArray.length; ++i10) {
                stringArrayArray[i10] = JSONHelper.createStringArrayFromJSONArray(jSONArrayArray[i10]);
            }
        }
        return stringArrayArray;
    }

    public static int[] createIntArrayFromJSONArray(JSONArray jSONArray) {
        int[] nArray = null;
        if (jSONArray != null) {
            nArray = new int[jSONArray.size()];
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                nArray[i10] = ((Number)jSONArray.get(i10)).intValue();
            }
        }
        return nArray;
    }

    public static void addJSONObjectToJSONObject(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject != null && jSONObject2 != null) {
            for (Object k10 : jSONObject2.keySet()) {
                jSONObject.put(k10, jSONObject2.get(k10));
            }
        }
    }

    public static void addPropertiesToJSONObject(Properties properties, JSONObject jSONObject) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                jSONObject.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void addPropertiesToJSONObject(Map map, Properties properties, JSONObject jSONObject) {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!map.containsKey(entry.getKey())) continue;
                jSONObject.put(map.get(entry.getKey()), entry.getValue());
            }
        }
    }

    public static JSONObject createJSONObjectFromProperties(Properties properties) {
        JSONObject jSONObject = null;
        if (properties != null) {
            jSONObject = new JSONObject();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                jSONObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jSONObject;
    }

    public static JSONObject createJSONObjectFromStringMap(Map<String, String> map) {
        JSONObject jSONObject = null;
        if (map != null) {
            jSONObject = new JSONObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jSONObject.put(entry.getKey(), entry.getValue());
            }
        }
        return jSONObject;
    }

    public static JSONObject createJSONObjectFromMap(Map map) {
        JSONObject jSONObject = null;
        if (map != null) {
            jSONObject = new JSONObject();
            for (Object k10 : map.keySet()) {
                try {
                    jSONObject.put(k10, map.get(k10));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger logger = Log.getCMXClientLogger();
                    DataLogger.logThrowable(logger, illegalArgumentException);
                }
            }
        }
        return jSONObject;
    }

    public static JSONArray createJSONArrayFromStringArray(String[] stringArray) {
        JSONArray jSONArray = null;
        if (stringArray != null) {
            jSONArray = new JSONArray();
            for (String string : stringArray) {
                jSONArray.add(string);
            }
        }
        return jSONArray;
    }
}

