/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.impl;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.deser.std.StdDeserializer;

public class UnsupportedTypeDeserializer
extends StdDeserializer<Object> {
    protected final JavaType _type;
    protected final String _message;

    public UnsupportedTypeDeserializer(JavaType t, String m) {
        super(t);
        this._type = t;
        this._message = m;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object value;
        if (p.currentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && ((value = p.getEmbeddedObject()) == null || this._type.getRawClass().isAssignableFrom(value.getClass()))) {
            return value;
        }
        ctxt.reportBadDefinition(this._type, this._message);
        return null;
    }
}

