/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public class DFAStateNode
extends DFAAbstractStateNode {
    private static final byte FLAG_FINAL_STATE = 1;
    private static final byte FLAG_ANCHORED_FINAL_STATE = 2;
    private static final byte FLAG_HAS_BACKWARD_PREFIX_STATE = 4;
    private static final byte FLAG_UTF_16_MUST_DECODE = 8;
    private static final byte FLAG_GUARDED_FINAL_STATE = 16;
    private static final byte FLAG_GUARDED_ANCHORED_FINAL_STATE = 32;
    private final byte flags;
    private final short loopTransitionIndex;
    private final short indexOfNodeId;
    private final byte indexOfIsFast;
    private final Matchers matchers;
    private final short anchoredFinalSuccessor;

    public DFAStateNode(short id, byte flags, short loopTransitionIndex, short indexOfNodeId, byte indexOfIsFast, short[] successors, Matchers matchers, short anchoredFinalSuccessor) {
        super(id, successors);
        assert (id > 0);
        this.flags = flags;
        this.loopTransitionIndex = loopTransitionIndex;
        this.indexOfNodeId = indexOfNodeId;
        this.indexOfIsFast = indexOfIsFast;
        this.matchers = matchers;
        this.anchoredFinalSuccessor = anchoredFinalSuccessor;
    }

    public static byte buildFlags(boolean finalState, boolean anchoredFinalState, boolean hasBackwardPrefixState, boolean utf16MustDecode, boolean guardedFinalState, boolean guardedAnchoredFinalState) {
        byte flags = 0;
        if (finalState) {
            flags = (byte)(flags | 1);
        }
        if (anchoredFinalState) {
            flags = (byte)(flags | 2);
        }
        if (hasBackwardPrefixState) {
            flags = (byte)(flags | 4);
        }
        if (utf16MustDecode) {
            flags = (byte)(flags | 8);
        }
        if (guardedFinalState) {
            flags = (byte)(flags | 0x10);
        }
        if (guardedAnchoredFinalState) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    public final Matchers getMatchers() {
        return this.matchers;
    }

    public final SequentialMatchers getSequentialMatchers() {
        return (SequentialMatchers)this.matchers;
    }

    public boolean isFinalState() {
        return this.flagIsSet((byte)1);
    }

    public boolean isGuardedFinalState() {
        return this.flagIsSet((byte)16);
    }

    public boolean isGuardedAnchoredFinalState() {
        return this.flagIsSet((byte)32);
    }

    public boolean isAnchoredFinalState() {
        return this.flagIsSet((byte)2);
    }

    public boolean hasBackwardPrefixState() {
        return this.flagIsSet((byte)4);
    }

    public boolean utf16MustDecode() {
        return this.flagIsSet((byte)8);
    }

    private boolean flagIsSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    public boolean hasLoopToSelf() {
        return this.loopTransitionIndex >= 0;
    }

    short getLoopToSelf() {
        assert (this.hasLoopToSelf());
        return this.loopTransitionIndex;
    }

    boolean treeTransitionMatching() {
        return this.matchers instanceof AllTransitionsInOneTreeMatcher;
    }

    AllTransitionsInOneTreeMatcher getTreeMatcher() {
        return (AllTransitionsInOneTreeMatcher)this.matchers;
    }

    public boolean hasIndexOfNodeId() {
        return this.indexOfNodeId >= 0;
    }

    public int getIndexOfNodeId() {
        return this.indexOfNodeId;
    }

    int getBackwardPrefixStateIndex() {
        assert (this.hasBackwardPrefixState());
        return this.getSuccessors().length - 1;
    }

    public short getAnchoredFinalSuccessor() {
        return this.anchoredFinalSuccessor;
    }

    boolean canDoIndexOf(TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant((Object)codeRange);
        CompilerAsserts.partialEvaluationConstant((int)codeRange.ordinal());
        return this.hasLoopToSelf() && this.hasIndexOfNodeId() && (this.indexOfIsFast & 1 << codeRange.ordinal()) != 0;
    }

    boolean beforeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        return this.checkFinalState(locals, executor);
    }

    void afterIndexOf(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex, TruffleString.CodeRange codeRange) {
        locals.setIndex(postLoopIndex);
        this.checkFinalState(locals, executor);
    }

    boolean checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        if (this.isFinalState()) {
            this.storeResult(locals, executor, false);
        }
        return false;
    }

    void atEnd(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean inputAtEnd) {
        boolean anchored;
        CompilerAsserts.partialEvaluationConstant((Object)this);
        boolean bl = anchored = this.isAnchoredFinalState() && inputAtEnd;
        if (this.isFinalState() || anchored) {
            this.storeResult(locals, executor, anchored);
        }
    }

    void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean anchored) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        locals.setResultInt(locals.getIndex());
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        DebugUtil.appendNodeId(sb, this.getId()).append(": ");
        if (!this.treeTransitionMatching()) {
            sb.append(this.getSequentialMatchers().size()).append(" successors");
        }
        if (this.isAnchoredFinalState()) {
            sb.append(", AFS");
        }
        if (this.isFinalState()) {
            sb.append(", FS");
        }
        sb.append(":\n");
        if (this.treeTransitionMatching()) {
            sb.append("      ").append(this.getTreeMatcher()).append("\n      successors: ").append(Arrays.toString(this.successors)).append("\n");
        } else {
            for (int i = 0; i < this.getSequentialMatchers().size(); ++i) {
                sb.append("      ").append(i).append(": ").append(this.getSequentialMatchers().toString(i)).append(" -> ");
                DebugUtil.appendNodeId(sb, this.getSuccessors()[i]).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonArray transitions = Json.array(new JsonConvertible[0]);
        if (this.matchers != null) {
            for (int i = 0; i < this.getSequentialMatchers().size(); ++i) {
                transitions.append(Json.obj(Json.prop("matcher", this.getSequentialMatchers().toString(i)), Json.prop("target", this.successors[i])));
            }
        }
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", this.isAnchoredFinalState() || this.isGuardedAnchoredFinalState()), Json.prop("finalState", this.isFinalState() || this.isGuardedFinalState()), Json.prop("loopToSelf", this.hasLoopToSelf()), Json.prop("transitions", transitions));
    }
}

