/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CCharByteArray
extends AggregateByteArray {
    char[] charArray;
    DBConversion conversion;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T2CCharByteArray(char[] _charArray, ByteArray _extension) {
        super(PhysicalConnection.EMPTY_BYTE_ARRAY, _extension);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$6, null, _charArray, _extension);
            }
            this.charArray = _charArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    long length() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$0, this, new Object[0]);
            }
            long l2 = (long)this.charArray.length + this.extension.length();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$0, this, l2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$0, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setChars(char[] cArray) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$1, this, new Object[]{cArray});
            }
            this.charArray = _chars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setDBConversion(DBConversion dBConversion) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _conversion;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$2, this, dBConversion);
            }
            this.conversion = _conversion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void out_lengthInChars;
            void charSet;
            void lengthInChars;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, l2, n2, characterSet, nArray);
            }
            if (offset < (long)this.charArray.length) {
                char[] returnValue = new char[lengthInChars];
                System.arraycopy(this.charArray, (int)offset, returnValue, 0, (int)lengthInChars);
                out_lengthInChars[0] = lengthInChars;
                char[] cArray = returnValue;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, cArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, null);
                }
                return returnValue;
            }
            char[] cArray = this.extension.getChars((long)(offset - (long)this.charArray.length), (int)lengthInChars, (CharacterSet)charSet, (int[])out_lengthInChars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, cArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, null);
            }
            return cArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    void get(long l2, byte[] byArray, int n2, int n3) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void destOffset;
            void dest;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$4, this, l2, byArray, n2, n3);
            }
            if (offset < (long)this.charArray.length) {
                try {
                    int n4 = this.conversion.javaCharsToCHARBytes(this.charArray, (int)offset, (byte[])dest, (int)destOffset, (int)length);
                }
                catch (SQLException ea) {
                    if (bl) {
                        this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "T2CCharByteArray, conversion exception: " + ea);
                    }
                }
            } else {
                this.extension.get((long)(offset - (long)this.charArray.length), (byte[])dest, (int)destOffset, (int)length);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    byte get(long l2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, l2);
            }
            if (index < (long)this.charArray.length) {
                byte by = (byte)(this.charArray[(int)index] & 0xFF);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, by);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, null);
                }
                return by;
            }
            byte by = this.extension.get((long)(index - (long)this.charArray.length));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, by);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CCharByteArray.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$6 = T2CCharByteArray.class.getDeclaredConstructor(char[].class, ByteArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T2CCharByteArray.class.getDeclaredMethod("get", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T2CCharByteArray.class.getDeclaredMethod("get", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T2CCharByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CCharByteArray.class.getDeclaredMethod("setDBConversion", DBConversion.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CCharByteArray.class.getDeclaredMethod("setChars", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CCharByteArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

