# Copyright (c) 2025-2026, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import ccx
from _typeshed import Incomplete
from nvmath.internal.package_ifc import StreamHolder as StreamHolder
from typing import Any, ClassVar

__pyx_capi__: dict
__reduce_cython__: _cython_3_1_2.cython_function_or_method
__setstate_cython__: _cython_3_1_2.cython_function_or_method
__test__: dict
free_reserved_memory: _cython_3_1_2.cython_function_or_method
get_device_current_memory_pool: _cython_3_1_2.cython_function_or_method

class MemAsyncAllocation:
    handle: Incomplete
    ptr: Incomplete
    size: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def close(self, stream=...) -> Any: ...
    def __reduce__(self): ...

class MemAsyncAllocationFinalizer:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __reduce__(self): ...

class MemAsyncPool:
    __pyx_vtable__: ClassVar[PyCapsule] = ...
    default_stream: Incomplete
    default_stream_ptr: Incomplete
    device_id: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def allocate(self, int64_tsize, stream: StreamHolder | ccx.Stream, logger=...) -> Any: ...
    def free_reserved_memory(self) -> Any: ...
    def get_limit(self) -> uint64_t: ...
    def get_reserved_memory_size(self) -> uint64_t: ...
    def get_used_memory_size(self) -> uint64_t: ...
    def set_limit(self, uint64_tlimit) -> Any: ...
    def __reduce__(self): ...

class MemoryPointer:
    owner: owner
    ptr: ptr
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __reduce__(self): ...
