/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.CliOptions;
import net.sourceforge.plantuml.file.FileWatcher;
import net.sourceforge.plantuml.log.Logme;

public class DirWatcher2 {
    private final File dir;
    private final CliOptions option;
    private final String pattern;
    private final Map<File, FileWatcher> modifieds = new ConcurrentHashMap<File, FileWatcher>();
    private final ExecutorService executorService;

    public DirWatcher2(File dir, CliOptions option, String pattern) {
        this.dir = dir;
        this.option = option;
        this.pattern = pattern;
        int nb = CliOptions.defaultNbThreads();
        this.executorService = Executors.newFixedThreadPool(nb);
    }

    public Map<File, Future<List<GeneratedImage>>> buildCreatedFiles() throws IOException, InterruptedException {
        TreeMap<File, Future<List<GeneratedImage>>> result = new TreeMap<File, Future<List<GeneratedImage>>>();
        if (this.dir.listFiles() != null) {
            for (final File f : this.dir.listFiles()) {
                FileWatcher watcher;
                if (!f.isFile() || !this.fileToProcess(f.getName()) || (watcher = this.modifieds.get(f)) != null && !watcher.hasChanged()) continue;
                final SourceFileReader sourceFileReader = new SourceFileReader(this.option.getDefaultDefines(f), f, this.option.getOutputDir(), this.option.getConfig(), this.option.getString(CliFlag.CHARSET), this.option.getFileFormatOption());
                this.modifieds.put(f, new FileWatcher(Collections.singleton(f)));
                Future<List<GeneratedImage>> value = this.executorService.submit(new Callable<List<GeneratedImage>>(){
                    final /* synthetic */ DirWatcher2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public List<GeneratedImage> call() throws Exception {
                        try {
                            List<GeneratedImage> generatedImages = sourceFileReader.getGeneratedImages();
                            Set<File> files = sourceFileReader.getIncludedFiles();
                            files.add(f);
                            this.this$0.modifieds.put(f, new FileWatcher(files));
                            return Collections.unmodifiableList(generatedImages);
                        }
                        catch (Exception e) {
                            Logme.error(e);
                            return Collections.emptyList();
                        }
                    }
                });
                result.put(f, value);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private boolean fileToProcess(String name) {
        return name.matches(this.pattern);
    }

    public final File getDir() {
        return this.dir;
    }

    public void cancel() {
        this.executorService.shutdownNow();
    }

    public void waitEnd() throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }
}

